/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.client;

import bitel.billing.common.VersionInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.script.client.EventScriptTabPanel;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.bgbilling.kernel.script.common.bean.EventType;
import ru.bitel.bgbilling.kernel.script.common.service.EventScriptService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class EventFunctionsPanel
extends BGUPanel {
    private final Map<String, EventType> eventTypeMap = new HashMap<String, EventType>();
    private EventScriptTabPanel parentPanel;
    private EventScriptService service;
    private BGUTable table;
    private EventScriptLinkTableModel model;
    private BGUComboBox<IdTitle> scriptCombo;
    private EventFunctionEditor scriptEditor = new EventFunctionEditor();
    private BGEditor editor = new BGEditor();
    private boolean global = false;

    public EventFunctionsPanel(boolean global, EventScriptTabPanel parent) {
        this.global = global;
        this.parentPanel = parent;
        this.scriptCombo = this.parentPanel.getScriptCombo();
    }

    @Override
    protected void jbInit() {
        this.model = new EventScriptLinkTableModel(EventScriptLinkTableModel.class.getName());
        this.table = new BGUTable(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    EventFunctionsPanel.this.performAction("edit");
                }
            }
        });
        this.editor.addForm(BGSwingUtilites.wrapBorder(this.scriptEditor, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.scriptCombo.addActionListener(e -> this.performAction(this.parentPanel.SCRIPT_SELECTED));
        this.editor.setVisible(false);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                EventFunctionsPanel.this.service = ((ClientContext)EventFunctionsPanel.this.getContext()).getPort(EventScriptService.class);
                if (EventFunctionsPanel.this.eventTypeMap.isEmpty()) {
                    List<EventType> events = EventFunctionsPanel.this.service.getEventTypeList(EventFunctionsPanel.this.global ? 0 : 1, true);
                    events.forEach(e -> EventFunctionsPanel.this.eventTypeMap.put(e.toKey(), (EventType)e));
                    EventFunctionsPanel.this.scriptEditor.eventTypeList.setData(events);
                }
                EventFunctionsPanel.this.scriptEditor.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction(this.parentPanel.SCRIPT_SELECTED, ""){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                IdTitle item;
                IdTitle idTitle = item = EventFunctionsPanel.this.global ? new IdTitle(0, "") : (IdTitle)EventFunctionsPanel.this.scriptCombo.getSelectedItem();
                if (item != null) {
                    EventFunctionsPanel.this.model.setData(EventFunctionsPanel.this.service.getEventLinksByScript(item.getId()));
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", ""){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                EventScriptLink scriptLink = (EventScriptLink)EventFunctionsPanel.this.model.getSelectedRow();
                if (scriptLink != null && BGSwingUtilites.confirmDelete("", scriptLink)) {
                    EventFunctionsPanel.this.service.deleteEventScriptLink(scriptLink.getId());
                    EventFunctionsPanel.this.performAction("refresh");
                    EventFunctionsPanel.this.performAction(EventFunctionsPanel.this.parentPanel.SCRIPT_SELECTED);
                }
            }
        };
    }

    private class EventFunctionEditor
    extends BGUPanel {
        private EventScriptLink current;
        private BGTextField titleText = new BGTextField();
        private EventPanel eventPanel = new EventPanel();
        private TitlePanel eventTitlePanel = new TitlePanel("\u0421\u043e\u0431\u044b\u0442\u0438\u0435: ", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435...");
        private TitlePanel classTitlePanel = new TitlePanel("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430: ", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u043b\u0430\u0441\u0441...");
        private NewClassPanel newClassPanel = new NewClassPanel();
        private BGUList<EventType> eventTypeList = new BGUList();
        private DynamicClassChooser chooser = new DynamicClassChooser(false, 1);

        private EventFunctionEditor() {
        }

        @Override
        protected void jbInit() {
            this.chooser.setNewClass(false);
            this.chooser.getClassNamesList().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.newClassPanel.className.setText(this.chooser.getSelectedClass());
                }
            });
            this.newClassPanel.newButton.addActionListener(e -> {
                if (this.newClassPanel.className.getText().isEmpty()) {
                    ClientUtils.showErrorMessageDialog("\u0412\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u0430!");
                } else {
                    this.chooser.setNewNameClass(this.newClassPanel.className.getText());
                    this.chooser.performAction("new_class");
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.getTitlePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.getEventAndClassPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        }

        private JPanel getTitlePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.titleText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            return panel;
        }

        private JPanel getEventAndClassPanel() {
            JPanel panel = new JPanel(new GridLayout(1, 2));
            panel.setMinimumSize(new Dimension(100, 300));
            panel.setPreferredSize(new Dimension(100, 300));
            panel.add(this.getEventPanel());
            panel.add(this.getClassPanel());
            return panel;
        }

        private JPanel getEventPanel() {
            this.eventTypeList.setSelectionMode(0);
            this.eventTypeList.addListSelectionListener(e -> this.eventPanel.setEventClassName((EventType)this.eventTypeList.getSelectedValue()));
            this.eventTitlePanel.getButton().addActionListener(e -> {
                if (!this.eventTypeList.isEnabled()) {
                    this.eventTypeList.setEnabled(true);
                    this.eventTitlePanel.getButton().setVisible(false);
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.eventTitlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JScrollPane(this.eventTypeList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0431\u044b\u0442\u0438\u044f: "), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.eventPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getClassPanel() {
            this.classTitlePanel.getButton().addActionListener(e -> {
                if (!this.chooser.isEnabled()) {
                    this.chooser.setEnabled(true);
                    this.classTitlePanel.getButton().setVisible(false);
                    this.newClassPanel.setEnabled(true);
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.classTitlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.chooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430: "), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.newClassPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    EventFunctionEditor.this.chooser.setIfaceName(EventFunctionsPanel.this.service.getInterfaceName());
                    EventFunctionEditor.this.chooser.setSuperclassName(EventFunctionsPanel.this.service.getSuperclassName());
                    EventFunctionEditor.this.chooser.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (!EventFunctionsPanel.this.global) {
                        if (EventFunctionsPanel.this.scriptCombo.getSelectedItem() == null) {
                            return;
                        }
                        EventFunctionsPanel.this.scriptCombo.setEnabled(false);
                    }
                    EventFunctionEditor.this.current = new EventScriptLink();
                    EventFunctionEditor.this.titleText.setText("");
                    EventFunctionEditor.this.chooser.clearSelection();
                    EventFunctionEditor.this.chooser.setEnabled(true);
                    EventFunctionEditor.this.chooser.setToolTipText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u0432\u043e\u0439\u043d\u043e\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u0430\"");
                    EventFunctionEditor.this.eventTypeList.clearSelection();
                    EventFunctionEditor.this.eventPanel.setEventClassName(null);
                    EventFunctionEditor.this.eventTypeList.setEnabled(true);
                    EventFunctionEditor.this.newClassPanel.setEnabled(true);
                    EventFunctionEditor.this.eventTitlePanel.getButton().setVisible(false);
                    EventFunctionEditor.this.classTitlePanel.getButton().setVisible(false);
                    EventFunctionEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (!EventFunctionsPanel.this.global && EventFunctionsPanel.this.scriptCombo.getSelectedItem() == null) {
                        return;
                    }
                    EventFunctionEditor.this.current = (EventScriptLink)EventFunctionsPanel.this.model.getSelectedRow();
                    if (EventFunctionEditor.this.current == null) {
                        throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442!");
                    }
                    if (!EventFunctionsPanel.this.global) {
                        EventFunctionsPanel.this.scriptCombo.setEnabled(false);
                    }
                    EventFunctionEditor.this.titleText.setText(EventFunctionEditor.this.current.getTitle());
                    EventFunctionEditor.this.chooser.setSelectedItem(EventFunctionEditor.this.current.getClassName());
                    EventFunctionEditor.this.chooser.setEnabled(false);
                    EventFunctionEditor.this.chooser.setToolTipText("");
                    EventType eventType = EventFunctionsPanel.this.eventTypeMap.get(EventFunctionEditor.this.current.getEventKey());
                    if (eventType != null) {
                        EventFunctionEditor.this.eventTypeList.setSelectedValue(eventType, true);
                        EventFunctionEditor.this.eventTypeList.setEnabled(false);
                    }
                    EventFunctionEditor.this.eventPanel.setEventClassName(eventType);
                    EventFunctionEditor.this.newClassPanel.setEnabled(false);
                    EventFunctionEditor.this.eventTitlePanel.getButton().setVisible(true);
                    EventFunctionEditor.this.classTitlePanel.getButton().setVisible(true);
                    EventFunctionEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (EventFunctionEditor.this.current != null) {
                        EventFunctionsPanel.this.service.deleteEventScriptLink(EventFunctionEditor.this.current.getId());
                        EventFunctionsPanel.this.performAction("refresh");
                    }
                    EventFunctionEditor.this.performActionClose();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (EventFunctionEditor.this.eventTypeList.getSelectedValue() == null) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0435");
                    }
                    if (Utils.isBlankString(EventFunctionEditor.this.chooser.getSelectedClass())) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \"\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\"");
                    }
                    if (Utils.isBlankString(EventFunctionEditor.this.titleText.getText())) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430");
                    }
                    EventFunctionEditor.this.current.setTitle(EventFunctionEditor.this.titleText.getText());
                    EventFunctionEditor.this.current.setClassName(EventFunctionEditor.this.chooser.getSelectedClass());
                    EventFunctionEditor.this.current.setEventKey(((EventType)EventFunctionEditor.this.eventTypeList.getSelectedValue()).toKey());
                    EventFunctionEditor.this.current.setScriptId(EventFunctionsPanel.this.global ? 0 : ((IdTitle)EventFunctionsPanel.this.scriptCombo.getSelectedItem()).getId());
                    EventFunctionsPanel.this.service.updateEventScriptLink(EventFunctionEditor.this.current);
                    EventFunctionEditor.this.performActionClose();
                    EventFunctionsPanel.this.performAction("refresh");
                    EventFunctionsPanel.this.performAction(EventFunctionsPanel.this.parentPanel.SCRIPT_SELECTED);
                    EventFunctionsPanel.this.scriptCombo.setEnabled(true);
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    EventFunctionsPanel.this.scriptCombo.setEnabled(true);
                    EventFunctionsPanel.this.editor.setVisible(false);
                }
            };
        }
    }

    class EventScriptLinkTableModel
    extends BGTableModel<EventScriptLink> {
        public EventScriptLinkTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 80, 80, 80, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0431\u044b\u0442\u0438\u0435", "eventId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441", "className", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(EventScriptLink val, int column) throws BGException {
            if (column == 2) {
                String key = val.getEventKey();
                EventType eventType = EventFunctionsPanel.this.eventTypeMap.get(key);
                return eventType != null ? eventType.getTitle() : "??? (" + key + ")";
            }
            return super.getValue(val, column);
        }
    }

    class EventPanel
    extends JPanel {
        private JTextField eventClassName;
        private BGButton docsButton;

        EventPanel() {
            super(new GridBagLayout());
            this.eventClassName = new JTextField(30);
            this.docsButton = new BGButton("javadocs");
            this.add((Component)this.eventClassName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.docsButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            Color bgColor = this.eventClassName.getBackground();
            this.eventClassName.setEditable(false);
            this.eventClassName.setBackground(bgColor);
            this.docsButton.addActionListener(actionEvent -> {
                if (actionEvent.getActionCommand() != null && !actionEvent.getActionCommand().isEmpty()) {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            String uri = actionEvent.getActionCommand().replace('.', '/');
                            desktop.browse(new URI("https://bgbilling.ru/v" + VersionInfo.getVersionInfo("").getVersion() + "/javadoc/" + uri + ".html"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        public void setEventClassName(EventType eventType) {
            String actionCommand = eventType != null ? eventType.getEventId() : "";
            this.eventClassName.setText(actionCommand);
            this.docsButton.setActionCommand(actionCommand);
        }
    }

    class TitlePanel
    extends JPanel {
        private JLabel label;
        private JButton button;

        TitlePanel(String title, String buttonText) {
            super(new GridBagLayout());
            this.label = new JLabel();
            this.button = new JButton();
            this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.label.setText(title);
            this.button.setText(buttonText);
        }

        public JButton getButton() {
            return this.button;
        }
    }

    class NewClassPanel
    extends JPanel {
        private JTextField className;
        private BGButton newButton;

        NewClassPanel() {
            super(new GridBagLayout());
            this.className = new JTextField(30);
            this.newButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c...");
            this.add((Component)this.className, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.newButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.className.setEditable(enabled);
            this.newButton.setEnabled(enabled);
        }

        public JTextField getClassName() {
            return this.className;
        }

        public BGButton getNewButton() {
            return this.newButton;
        }
    }
}

