/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public abstract class MultiSelectTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon addIcon = ClientUtils.getIcon("item_add");
    private static Icon deleteIcon = ClientUtils.getIcon("item_delete");
    private JLabel view = new JLabel();
    private Directory dir;
    private JPanel editorsContainer = new JPanel(new GridBagLayout());
    private List<Editor> editorList = new ArrayList<Editor>();
    private JPanel editor = new JPanel(new GridBagLayout());
    private JRadioButton modeOr;
    private JRadioButton modeAnd;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(this.getIcon());
        this.makeEditor();
    }

    protected Directory getDirectory() {
        if (this.dir == null) {
            this.dir = this.getDirManager().getDirectory(this.getDirName());
        }
        return this.dir;
    }

    protected boolean needMode() {
        return false;
    }

    protected boolean canEmpty() {
        return false;
    }

    private void makeEditor() {
        this.editor.add((Component)new JLabel(this.getViewLabel()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JScrollPane editorsScroll = new JScrollPane(this.editorsContainer);
        editorsScroll.setMinimumSize(new Dimension(380, 200));
        editorsScroll.setPreferredSize(new Dimension(380, 200));
        editorsScroll.setHorizontalScrollBarPolicy(31);
        this.editor.add((Component)editorsScroll, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        BGButtonPanelOkCancel yesNoPane = new BGButtonPanelOkCancel();
        if (this.needMode()) {
            this.modeOr = new JRadioButton("\u0418\u041b\u0418");
            this.modeAnd = new JRadioButton("\u0418");
            ButtonGroup group = new ButtonGroup();
            group.add(this.modeOr);
            group.add(this.modeAnd);
            JPanel panel = new JPanel();
            panel.add(new JLabel("\u0420\u0435\u0436\u0438\u043c:"));
            panel.add(this.modeOr);
            panel.add(this.modeAnd);
            this.editor.add((Component)panel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            JPanel bottomPanel = this.getBottomPanel();
            if (bottomPanel != null) {
                this.editor.add((Component)bottomPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            }
            this.editor.add((Component)yesNoPane, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            JPanel bottomPanel = this.getBottomPanel();
            if (bottomPanel != null) {
                this.editor.add((Component)bottomPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            }
            this.editor.add((Component)yesNoPane, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        yesNoPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command != null) {
                    if (command.equals("ok")) {
                        MultiSelectTariffTreeNode.this.serializeData();
                        MultiSelectTariffTreeNode.this.saveData();
                        MultiSelectTariffTreeNode.this.tree.updateTree();
                        MultiSelectTariffTreeNode.this.tree.getViewableTree().stopEditing();
                    } else if (command.equals("cancel")) {
                        MultiSelectTariffTreeNode.this.loadData();
                        MultiSelectTariffTreeNode.this.tree.getViewableTree().stopEditing();
                    }
                }
            }
        });
    }

    protected JPanel getBottomPanel() {
        return null;
    }

    @Override
    protected JPanel getEditorPanel() {
        return this.editor;
    }

    @Override
    public Component getEditor() {
        return this.editor;
    }

    @Override
    public Component getView() {
        Map<String, String> data = this.getDataInHash();
        List<Integer> sids = Utils.toIntegerList(data.get(this.getStoreKey()));
        StringBuffer str = new StringBuffer("<html>");
        str.append(this.getViewLabel(data));
        if (this.needMode()) {
            boolean modeOr = Utils.parseInt(data.get("mode"), 0) == 0;
            str.append("\u0440\u0435\u0436\u0438\u043c ").append(modeOr ? "\u0418\u041b\u0418" : "\u0418");
        }
        for (int sid : sids) {
            str.append("<br>&nbsp;&nbsp;&nbsp;-&nbsp;").append(this.getValue(sid));
        }
        this.view.setText(str.toString());
        return this.view;
    }

    protected String getValue(int sid) {
        if (this.getDirectory() != null) {
            return this.getDirectory().getValue(sid);
        }
        return "???[#" + sid + "]";
    }

    @Override
    protected void loadData() {
        this.editorList.clear();
        this.editorsContainer.removeAll();
        Map<String, String> data = this.getDataInHash();
        List<Integer> sids = Utils.toIntegerList(data.get(this.getStoreKey()));
        int pos = 0;
        for (int sid : sids) {
            Editor editor = new Editor(pos++);
            editor.setService(sid);
            this.addEditor(editor);
        }
        if (sids.size() == 0) {
            Editor editor = new Editor(0);
            this.addEditor(editor);
        }
        if (this.needMode()) {
            boolean modeOr;
            boolean bl = modeOr = Utils.parseInt(data.get("mode"), 0) == 0;
            if (modeOr) {
                this.modeOr.setSelected(true);
            } else {
                this.modeAnd.setSelected(true);
            }
        }
        this.loadDataImpl(data);
    }

    protected void loadDataImpl(Map<String, String> data) {
    }

    protected void setDataImpl(Map<String, String> data) {
    }

    @Override
    protected void serializeData() {
        ArrayList<Integer> sids = new ArrayList<Integer>();
        for (Editor editor : this.editorList) {
            sids.add(editor.getService());
        }
        if (this.canEmpty() && sids.size() == 1 && sids.contains(-1)) {
            sids.clear();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(this.getStoreKey(), Utils.toString(sids));
        if (this.needMode()) {
            data.put("mode", this.modeAnd.isSelected() ? "1" : "0");
        }
        this.setDataImpl(data);
        this.setDataInHash(data);
    }

    private void addEditor(Editor editor) {
        this.editorList.add(editor);
        this.editorsContainer.add((Component)editor.getPanel(), new GridBagConstraints(0, editor.getPos(), 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.updateUI();
    }

    protected abstract String getDirName();

    protected abstract String getViewLabel();

    protected String getViewLabel(Map<String, String> data) {
        return this.getViewLabel();
    }

    protected abstract String getStoreKey();

    protected abstract Icon getIcon();

    private class Editor
    implements ActionListener {
        private JPanel panel = new JPanel();
        private BGComboBox<IdTitle> serviceCombo = new BGComboBox();
        private int pos;

        public Editor(int pos) {
            this.pos = pos;
            this.serviceCombo.setMaximumSize(new Dimension(300, 24));
            this.serviceCombo.setPreferredSize(new Dimension(300, 24));
            MultiSelectTariffTreeNode.this.buildDirectoryCombo(MultiSelectTariffTreeNode.this.getDirectory(), this.serviceCombo);
            JButton addButton = new JButton(addIcon);
            addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
            addButton.setActionCommand("add");
            addButton.setMargin(new Insets(2, 2, 2, 2));
            JButton deleteButton = new JButton(deleteIcon);
            deleteButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            deleteButton.setActionCommand("delete");
            deleteButton.setMargin(new Insets(2, 2, 2, 2));
            this.panel.add(this.serviceCombo);
            this.panel.add(addButton);
            this.panel.add(deleteButton);
            addButton.addActionListener(this);
            deleteButton.addActionListener(this);
        }

        public int getPos() {
            return this.pos;
        }

        public void setService(int sid) {
            MultiSelectTariffTreeNode.this.setDirectoryItemSelection(this.serviceCombo, sid);
        }

        public int getService() {
            return MultiSelectTariffTreeNode.this.getIdFromDirectoryCombo(this.serviceCombo);
        }

        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("add")) {
                int pos = 0;
                int size = MultiSelectTariffTreeNode.this.editorList.size();
                if (size > 0) {
                    Editor lastEditor = MultiSelectTariffTreeNode.this.editorList.get(size - 1);
                    pos = lastEditor.getPos() + 1;
                }
                Editor editor = new Editor(pos);
                MultiSelectTariffTreeNode.this.addEditor(editor);
            } else if (MultiSelectTariffTreeNode.this.editorList.size() <= 1 && !MultiSelectTariffTreeNode.this.canEmpty()) {
                ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\n\u0414\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
            } else {
                MultiSelectTariffTreeNode.this.editorList.remove(this);
                MultiSelectTariffTreeNode.this.editorsContainer.remove(this.getPanel());
                MultiSelectTariffTreeNode.this.editor.updateUI();
            }
        }
    }
}

