/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.FolderTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AbstractTariffTreeBuilder {
    private static final Logger log = LogManager.getLogger();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Class<?>>> _typesClasses = new ConcurrentHashMap();

    public InputStream getModuleTariffConfigIS(String module) {
        return AbstractTariffTreeBuilder.class.getResourceAsStream("/ru/bitel/bgbilling/modules/" + module + "/common/tariff.xml");
    }

    protected ConcurrentHashMap<String, Class<?>> getTypesClasses(String module) {
        ConcurrentHashMap<String, Class<?>> result = this._typesClasses.get(module);
        if (result == null) {
            try (InputStream inputStream = this.getModuleTariffConfigIS(module);){
                if (inputStream != null) {
                    result = this.loadChildsClasses(module, XMLUtils.parseDocument(new InputSource(inputStream)));
                    this._typesClasses.put(module, result);
                } else {
                    log.error("inputStream is null for module=" + module);
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                e.printStackTrace();
            }
        }
        return result;
    }

    private ConcurrentHashMap<String, Class<?>> loadChildsClasses(String module, Document doc) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        if (doc != null) {
            for (Element item : XMLUtils.selectElements(doc, "/data/tree/node")) {
                String type = item.getAttribute("type");
                String className = item.getAttribute("class2");
                if ("bitel.billing.server.tariff.DefaultTariffTreeNode".equals(className)) {
                    className = FolderTariffTreeNode.class.getName();
                }
                className = className.replace("bitel.billing.server.npay", "ru.bitel.bgbilling.module.npay.server.tariff");
                try {
                    Class<?> clazz = Class.forName(className);
                    result.put(type, clazz);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return result;
    }

    protected boolean addMTreeItems(Connection con, int tree_id, int mid, Element tree, boolean editable, int deep) throws BGException {
        boolean result = false;
        try {
            int mtree = 0;
            int mtreeParent = 0;
            String query = "SELECT id, parent_tree FROM module_tariff_tree WHERE mid=? AND tree_id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, mid);
            ps.setInt(2, tree_id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                mtree = rs.getInt(1);
                mtreeParent = rs.getInt(2);
                ps.close();
                if (mtreeParent == 0) {
                    query = "SELECT parent_tree FROM tariff_tree WHERE id=?";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, tree_id);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        mtreeParent = rs.getInt(1);
                    }
                    rs.close();
                    ps.close();
                }
                if (mtreeParent != 0) {
                    this.addMTreeItems(con, mtreeParent, mid, tree, false, deep + 1);
                }
                tree.setAttribute("id", String.valueOf(mtree));
                query = "SELECT id, type, parent_node, data FROM mtree_node WHERE mtree_id=? ORDER BY pos";
                ps = con.prepareStatement(query);
                ps.setInt(1, mtree);
                rs = ps.executeQuery();
                while (rs.next()) {
                    Element item = XMLUtils.createElement(tree, "item");
                    item.setAttribute("id", rs.getString(1));
                    item.setAttribute("type", rs.getString(2));
                    item.setAttribute("parent", rs.getString(3));
                    item.setAttribute("data", rs.getString(4));
                    item.setAttribute("editable", String.valueOf(editable));
                    item.setAttribute("deep", String.valueOf(deep));
                }
                rs.close();
                ps.close();
                result = true;
            }
            if (!ps.isClosed()) {
                ps.close();
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    protected final HashMap<String, String> getDataInHash(String _data) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer pairsSt = new StringTokenizer(_data, "%");
        while (pairsSt.hasMoreTokens()) {
            String pair = pairsSt.nextToken();
            StringTokenizer key_value = new StringTokenizer(pair, "&");
            if (key_value.countTokens() != 2) continue;
            String key = key_value.nextToken();
            String value = key_value.nextToken();
            result.put(key, value);
        }
        result.put("", _data);
        return result;
    }

    private Element getTreeElement(Connection con, int treeId, int mid) throws BGException {
        Document doc = XMLUtils.newDocument();
        Element tree = doc.createElement("tree");
        doc.appendChild(tree);
        boolean result = this.addMTreeItems(con, treeId, mid, tree, true, 0);
        return result ? tree : null;
    }

    protected TariffModuleTree loadTariffModuleTree(Connection con, int treeId, int mid, String module) throws BGException {
        TariffTreeNodeHolder root = null;
        Element tree = this.getTreeElement(con, treeId, mid);
        if (tree != null) {
            ConcurrentHashMap<String, Class<?>> typesClasses;
            NodeList nl = tree.getElementsByTagName("item");
            int size = nl.getLength();
            HashMap<Integer, List<TreeNode>> childsByParents = new HashMap<Integer, List<TreeNode>>();
            TreeNode rootNode = null;
            for (int i = 0; i < size; ++i) {
                Element item = (Element)nl.item(i);
                int id = Utils.parseInt(item.getAttribute("id"), -1);
                String type = item.getAttribute("type");
                String data = item.getAttribute("data");
                int deep = Integer.parseInt(item.getAttribute("deep"));
                int parent = Integer.parseInt(item.getAttribute("parent"));
                TreeNode node = new TreeNode();
                node.id = id;
                node.type = type;
                node.data = this.getDataInHash(data);
                node.deep = deep;
                node.parent = parent;
                if (parent == 0) {
                    rootNode = node;
                    continue;
                }
                ArrayList<TreeNode> childs = (ArrayList<TreeNode>)childsByParents.get(parent);
                if (childs == null) {
                    childs = new ArrayList<TreeNode>();
                    childsByParents.put(parent, childs);
                }
                childs.add(node);
            }
            if (rootNode != null && (typesClasses = this.getTypesClasses(module)) != null) {
                root = this.loadChild(treeId, typesClasses, rootNode, childsByParents, con, mid);
            }
        }
        if (root == null) {
            if (log.isDebugEnabled()) {
                log.debug("Root of tree not found for tree:" + treeId + " module:" + mid);
            }
            return null;
        }
        return new TariffModuleTree(root, treeId, mid, module);
    }

    private TariffTreeNodeHolder loadChild(int treeId, ConcurrentHashMap<String, Class<?>> typesClasses, TreeNode node, Map<Integer, List<TreeNode>> childsByParents, Connection con, int moduleId) {
        Class<?> clazz;
        List<TreeNode> children = childsByParents.remove(node.id);
        ArrayList<TariffTreeNodeHolder> childrenNodes = null;
        if (children != null) {
            childrenNodes = new ArrayList<TariffTreeNodeHolder>();
            for (TreeNode child : children) {
                TariffTreeNodeHolder n = this.loadChild(treeId, typesClasses, child, childsByParents, con, moduleId);
                if (n == null) continue;
                childrenNodes.add(n);
            }
        }
        if ((clazz = typesClasses.get(node.type)) != null) {
            try {
                TariffTreeNode result;
                Constructor<?> constr;
                try {
                    constr = clazz.getConstructor(Integer.TYPE, ParameterMap.class);
                    result = (TariffTreeNode)constr.newInstance(node.id, new ParameterMap.DefaultParameterMap(node.data));
                }
                catch (NoSuchMethodException ex) {
                    try {
                        constr = clazz.getConstructor(Connection.class, Integer.TYPE, Integer.TYPE, ParameterMap.class);
                        result = (TariffTreeNode)constr.newInstance(con, moduleId, node.id, new ParameterMap.DefaultParameterMap(node.data));
                    }
                    catch (NoSuchMethodException ex2) {
                        throw ex;
                    }
                }
                TariffTreeNodeHolder[] ch = childrenNodes != null ? childrenNodes.toArray(new TariffTreeNodeHolder[childrenNodes.size()]) : null;
                long treeNodeId = 0xFFFFFFFF00000000L & (long)treeId << 32 | 0xFFFFFFFFL & (long)node.id;
                return new TariffTreeNodeHolder(treeNodeId, node.deep, result, ch);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected class TreeNode {
        int id;
        int parent;
        int deep;
        String type;
        Map<String, String> data;

        protected TreeNode() {
        }
    }
}

