/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.TimeUnit;

public class FrequencyCounter {
    private final int period;
    private final long[] amount;
    private final long delimeter;
    private long currentPeriod = 0L;

    public FrequencyCounter(long period, TimeUnit unit) {
        TimeUnit lessUnit = FrequencyCounter.getLessTimeUnit(unit);
        this.period = (int)lessUnit.convert(period, unit) + 1;
        this.amount = new long[this.period];
        this.delimeter = TimeUnit.MILLISECONDS.convert(1L, lessUnit);
    }

    private static TimeUnit getLessTimeUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.HOURS;
            }
            case HOURS: {
                return TimeUnit.MINUTES;
            }
        }
        return TimeUnit.SECONDS;
    }

    public synchronized void add(long nowMillis, long count) {
        long currentPeriod = nowMillis / this.delimeter;
        long delta = currentPeriod - this.currentPeriod;
        if (delta >= (long)this.period) {
            if ((delta -= (long)this.period) >= (long)this.period) {
                this.clear(0, this.period);
            } else {
                this.clear((int)this.currentPeriod % this.period, (int)delta);
            }
        } else {
            this.amount[(int)((currentPeriod + 1L) % (long)this.period)] = 0L;
        }
        this.currentPeriod = currentPeriod;
        int n = (int)(currentPeriod % (long)this.period);
        this.amount[n] = this.amount[n] + count;
    }

    public synchronized long addAndGet(long nowMillis, long count) {
        long currentPeriod = nowMillis / this.delimeter;
        long delta = currentPeriod - this.currentPeriod;
        if (delta >= (long)this.period) {
            if ((delta -= (long)this.period) >= (long)this.period) {
                this.clear(0, this.period);
            } else {
                this.clear((int)this.currentPeriod % this.period, (int)delta);
            }
        } else {
            this.amount[(int)((currentPeriod + 1L) % (long)this.period)] = 0L;
        }
        this.currentPeriod = currentPeriod;
        int n = (int)(currentPeriod % (long)this.period);
        this.amount[n] = this.amount[n] + count;
        long result = 0L;
        for (int i = 0; i < this.period; ++i) {
            result += this.amount[i];
        }
        return result;
    }

    public synchronized long get(long nowMillis) {
        long currentPeriod = nowMillis / this.delimeter;
        long delta = currentPeriod - this.currentPeriod;
        if (delta >= (long)this.period) {
            if ((delta -= (long)this.period) >= (long)this.period) {
                this.clear(0, this.period);
            } else {
                this.clear((int)this.currentPeriod % this.period, (int)delta);
            }
        } else {
            this.amount[(int)((currentPeriod + 1L) % (long)this.period)] = 0L;
        }
        this.currentPeriod = currentPeriod;
        long result = 0L;
        for (int i = 0; i < this.period; ++i) {
            result += this.amount[i];
        }
        return result;
    }

    private void clear(int pos, int length) {
        int i;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            this.amount[i] = 0L;
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            this.amount[i] = 0L;
        }
    }
}

