/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;

public class ActionFindContractLoginAlias
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String type = this.getParameter("type");
        String value = this.getParameter("value");
        int mid = this.getIntParameter("mid", -1);
        if (type == null || value == null || mid < 0) {
            return;
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if ("login".equals(type) && value != null && value.trim().length() > 0) {
            Map<String, List<String>> alias = this.getLoginAlias(mid);
            String query = "SELECT t1.id, t1.title, t2.id, t2.login FROM contract as t1, user_login_" + mid + " AS t2 WHERE t2.login=? AND t1.id=t2.cid ORDER BY t2.login";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Element row = this.createElement(data, "row");
                row.setAttribute("f0", rs.getString(1));
                row.setAttribute("f1", rs.getString(2));
                row.setAttribute("f2", rs.getString(3));
                row.setAttribute("f3", rs.getString(4));
                StringBuffer buf = new StringBuffer();
                List<String> list = alias.get(rs.getString(3));
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        buf.append(list.get(i));
                        buf.append(' ');
                    }
                }
                row.setAttribute("f4", buf.toString());
            }
            rs.close();
        } else if ("contract".equals(type) && value.trim().length() > 0) {
            Map<String, List<String>> alias = this.getLoginAlias(mid);
            String query = "SELECT t1.id, t1.title, t2.id, t2.login FROM contract as t1, user_login_" + mid + " as t2 where upper(t1.title) regexp ? and t1.id=t2.cid order by t1.title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Element row = this.createElement(data, "row");
                row.setAttribute("f0", rs.getString(1));
                row.setAttribute("f1", rs.getString(2));
                row.setAttribute("f2", rs.getString(3));
                row.setAttribute("f3", rs.getString(4));
                StringBuffer buf = new StringBuffer();
                List<String> list = alias.get(rs.getString(3));
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        buf.append(list.get(i));
                        buf.append(' ');
                    }
                }
                row.setAttribute("f4", buf.toString());
            }
            rs.close();
        } else if ("alias".equals(type) && value.trim().length() > 0) {
            String query = "SELECT t1.id, t1.title, t2.id, t2.login, t3.login_alias from contract as t1, user_login_" + mid + " as t2, user_alias_" + mid + " as t3 where upper(t3.login_alias) regexp ? and t1.id=t2.cid and t2.id=t3.login_id order by t3.login_alias";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Element row = this.createElement(data, "row");
                row.setAttribute("f0", rs.getString(1));
                row.setAttribute("f1", rs.getString(2));
                row.setAttribute("f2", rs.getString(3));
                row.setAttribute("f3", rs.getString(4));
                row.setAttribute("f4", rs.getString(5));
            }
            rs.close();
        }
    }

    private Map<String, List<String>> getLoginAlias(int mid) throws SQLException {
        HashMap<String, List<String>> alias = new HashMap<String, List<String>>();
        String query = "SELECT login_id, login_alias FROM user_alias_" + mid;
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String login_id = rs.getString(1);
            ArrayList<String> list = (ArrayList<String>)alias.get(login_id);
            if (list == null) {
                list = new ArrayList<String>();
                alias.put(login_id, list);
            }
            list.add(rs.getString(2));
        }
        rs.close();
        ps.close();
        return alias;
    }
}

