/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.object.action.base.ActionBase;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ModuleEntity;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ObjectType;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;

public class ActionObjectModuleTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        ObjectTypeManager typeManager;
        ObjectType type;
        int objectId = this.getIntParameter("object_id", -1);
        if (objectId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        ObjectManager objectManager = new ObjectManager(this.con);
        ContractObject object = objectManager.getObject(objectId);
        if (object != null && (type = (typeManager = new ObjectTypeManager(this.con)).getType(object.getTypeId())) != null) {
            ContractModuleManager contractModuleManager = new ContractModuleManager(this.con);
            Set<Integer> contractModuleIds = contractModuleManager.getContractModuleSet(object.getContractId());
            Element modules = this.createElement(this.rootNode, "modules");
            for (Integer moduleId : type.getModuleList()) {
                List<ModuleEntity> entityList;
                BGModule module;
                if (!contractModuleIds.contains(moduleId) || (module = ModuleCache.getInstance().getModule(moduleId)) == null) continue;
                Element moduleEl = this.createElement(modules, "module");
                moduleEl.setAttribute("id", String.valueOf(moduleId));
                moduleEl.setAttribute("name", module.getName());
                moduleEl.setAttribute("pack_client", module.getInstalledModule().getPackageClient());
                moduleEl.setAttribute("title", module.getTitle());
                ApplicationModule moduleBean = ModuleCache.getInstance().getApplicationModule(module.getName());
                if (moduleBean == null || (entityList = moduleBean.getObjectEntities(this.con, module.getId(), objectId)) == null) continue;
                for (ModuleEntity entity : entityList) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("module", module.getTitle());
                    row.setAttribute("data", entity.getName() + ": " + entity.getData());
                    row.setAttribute("period", entity.getPeriod());
                    row.setAttribute("comment", entity.getComment());
                }
            }
        }
    }
}

