/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.ObjectParam;
import bitel.billing.server.contract.object.bean.ParamValueManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ParamManager {
    private Connection con;
    private static final String TABLE_NAME = "object_param";

    public ParamManager(Connection con) {
        this.con = con;
    }

    public List<ObjectParam> getParamList() {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        try {
            String query = "SELECT * FROM object_param ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getParamFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ObjectParam> getParamList(int typeId) {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        try {
            String query = "SELECT * FROM object_param WHERE type=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getParamFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, ObjectParam> getParamMap() {
        HashMap<Integer, ObjectParam> result = new HashMap<Integer, ObjectParam>();
        try {
            String query = "SELECT * FROM object_param";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ObjectParam param = this.getParamFromRs(rs);
                result.put(param.getId(), param);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateParam(ObjectParam value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            int flags = value.isHistory() ? 1 : 0;
            flags |= value.isWrite() ? 2 : 0;
            flags |= value.isRead() ? 4 : 0;
            String querySet = " SET title=?, type=?, comment=?, flags=?";
            if (value.getId() <= 0) {
                query = "INSERT INTO object_param" + querySet;
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE object_param" + querySet + " WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, value.getId());
            }
            ps.setString(1, value.getTitle());
            ps.setInt(2, value.getTypeId());
            ps.setString(3, value.getComment());
            ps.setByte(4, (byte)flags);
            ps.executeUpdate();
            if (value.getId() <= 0) {
                value.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            ParamValueManager.resetParametersHistoryMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteParam(int id) {
        try {
            String query = "DELETE FROM object_param WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectParam getParam(int id) {
        ObjectParam result = null;
        try {
            String query = "SELECT * FROM object_param WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getParamFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ObjectParam getParamFromRs(ResultSet rs) throws SQLException {
        ObjectParam result = new ObjectParam();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type"));
        result.setComment(rs.getString("comment"));
        byte flags = rs.getByte("flags");
        result.setHistory((flags & 1) > 0);
        result.setWrite((flags & 2) > 0);
        result.setRead((flags & 4) > 0);
        return result;
    }
}

