/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class PaymentAndChargeTreeTablePanel
extends BGUPanel {
    private int mode = 0;
    private BGUTreeTable treeTable;
    private BGTreeTableModel<PaymentTypeItem> model = new BGTreeTableModel<PaymentTypeItem>("payments"){

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PaymentTypeItem.class, -1, 1000, -1, "title", true);
            this.addColumn("\u041a\u043e\u0434", 40, 40, -1, "id", true);
        }

        public Object getValue(PaymentTypeItem val, int column) throws BGException {
            switch (column) {
                case 1: {
                    if (val == this.root || val.getType() == 1) {
                        return "";
                    }
                }
                case 0: {
                    if (val != this.root) break;
                    return "\u0422\u0438\u043f\u044b";
                }
            }
            return super.getValue((Object)val, column);
        }
    };

    public PaymentAndChargeTreeTablePanel() {
        this.build();
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.treeTable = new BGUTreeTable(this.model);
        this.treeTable.setRowSorter(null);
        this.treeTable.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.treeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        try {
            if (this.mode == 0) {
                this.model.setData((Object)((PaymentService)((ClientContext)this.getContext()).getPort(PaymentService.class)).paymentTypeTree(0, false));
            } else {
                PaymentTypeItem chargeTree = ((ChargeService)((ClientContext)this.getContext()).getPort(ChargeService.class)).chargeTypeTree(0, this.mode == 2, false);
                chargeTree.sortByTitle();
                this.model.setData((Object)chargeTree);
            }
            this.treeTable.expand();
        }
        catch (BGException ex) {
            ((ClientContext)this.getContext()).processException((Throwable)ex);
        }
    }

    public Integer getSelectedId() {
        PaymentType payment = (PaymentType)((Object)this.model.getSelectedRow());
        if (payment == null || payment.getType() == 1) {
            return null;
        }
        return payment.getId();
    }

    public void setSelected(int paimentTypeId) {
        TreePath path = new TreePath((Object[])((PaymentTypeItem)((Object)this.model.getRoot())).findCodePath(paimentTypeId));
        this.treeTable.expandPath(path);
        this.treeTable.setSelectionPath(path);
        this.treeTable.scrollPathToVisible(path);
    }

    public void setMode(int tableMode) {
        this.mode = tableMode;
    }

    public int getMode() {
        return this.mode;
    }

    public BGUTreeTable getTreeTable() {
        return this.treeTable;
    }
}

