/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.service;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractSubPanelLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractSubPanelManage;
import ru.bitel.bgbilling.kernel.contract.limit.common.service.ContractSubPanelService;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.limit.common.service.ContractSubPanelService")
public class ContractSubPanelServiceImpl
extends AbstractService
implements ContractSubPanelService {
    @Override
    public SearchResult<ContractSubPanelLog> searchContractLimitLog(int contractId, Page page, Period period, String[] sort) throws BGException {
        SearchResult searchResult = new SearchResult();
        List list = searchResult.getList();
        searchResult.setPage(page);
        try {
            Calendar date1 = TimeUtils.convertDateToCalendar((Date)period.getDateFrom());
            Calendar date2 = TimeUtils.convertDateToCalendar((Date)period.getDateTo());
            LimitManager lm = new LimitManager(this.getConnection());
            for (LimitManager.UserLimitMove userLimitMove : lm.getUserLimitMove(contractId, date1, date2)) {
                ContractSubPanelLog log = new ContractSubPanelLog();
                log.setContractId(contractId);
                log.setDate1(userLimitMove.getDate1().getTime());
                log.setDate2(userLimitMove.getDate2().getTime());
                log.setSum(new BigDecimal(userLimitMove.getSumm()));
                switch (userLimitMove.getStatus()) {
                    case 0: {
                        log.setStatus("\u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        break;
                    }
                    case 1: {
                        log.setStatus("\u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        break;
                    }
                    case 2: {
                        log.setStatus("\u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        break;
                    }
                    default: {
                        log.setStatus("\u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043e");
                    }
                }
                list.add(log);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return searchResult;
    }

    @Override
    public SearchResult<ContractSubPanelManage> searchContractLimitManage(int contractId, Page page, String[] sort) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        try {
            searchResult.setList(new LimitManager(this.getConnection()).getContractManage((SearchResult<ContractSubPanelManage>)searchResult, contractId));
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }
}

