/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.database.server.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.database.common.service.DatabaseService;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.database.common.service.DatabaseService")
public class DatabaseServiceImpl
extends AbstractService
implements DatabaseService {
    @Override
    public List<String> getModulePluginList() throws BGException {
        ArrayList<String> list = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", 0);
        jsonObject.put("title", (Object)"\u042f\u0434\u0440\u043e");
        list.add(jsonObject.toString());
        ModuleManager moduleManager = new ModuleManager(this.getConnection());
        moduleManager.getModules(null).forEach(e -> {
            JSONObject json = new JSONObject();
            json.put("id", e.getId());
            json.put("title", (Object)e.getTitle());
            list.add(json.toString());
        });
        return list;
    }

    @Override
    public SearchResult<String> searchTableNames(int moduleId, String tableNameMask, String[] sort, Page page) throws BGException {
        Connection con = this.getConnection();
        SearchResult searchResult = new SearchResult(null, page);
        List list = searchResult.getList();
        String tableSchema = this.getSetup().get("database.table.schema", "bgbilling");
        String query = "SELECT SQL_CALC_FOUND_ROWS table_name AS `name`, ROUND((data_length + index_length) / 1024 / 1024, 2) `size` FROM information_schema.TABLES WHERE table_schema=? " + (Utils.notBlankString((String)tableNameMask) ? "AND table_name LIKE ?" : "") + " ORDER BY `size` DESC, table_name ASC" + (page != null ? page.sqlLimit() : "");
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setString(parameterIndex++, tableSchema);
            if (Utils.notBlankString((String)tableNameMask)) {
                psSelect.setString(parameterIndex++, tableNameMask);
            }
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                JSONObject json = new JSONObject();
                json.put("name", (Object)resultSet.getString("name"));
                json.put("subsystem", (Object)"?");
                json.put("size", (Object)resultSet.getBigDecimal("size"));
                list.add(json.toString());
            }
            page.setRecordCount(ServerUtils.foundRows(con));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    @Override
    public List<String> getTableInfo(String tableName) throws BGException {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String tableSchema = this.getSetup().get("database.table.schema", "bgbilling");
        String query = "SELECT * FROM information_schema.TABLES WHERE table_schema=? AND table_name=?";
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setString(parameterIndex++, tableSchema);
            psSelect.setString(parameterIndex++, tableName);
            ResultSet resultSet = psSelect.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                    JSONObject json = new JSONObject();
                    json.put("name", (Object)resultSetMetaData.getColumnName(column));
                    json.put("value", (Object)resultSet.getString(column));
                    list.add(json.toString());
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    @Override
    public List<String> getTableDataRecord(String tableName, int recordIndex) throws BGException {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + " LIMIT ?, 1";
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, recordIndex);
            ResultSet resultSet = psSelect.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                    JSONObject json = new JSONObject();
                    json.put("name", (Object)resultSetMetaData.getColumnName(column));
                    json.put("value", (Object)resultSet.getString(column));
                    list.add(json.toString());
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    @Override
    public List<String> getTableDataHeaders(String tableName) throws BGException {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + " LIMIT 1";
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            ResultSet resultSet = psSelect.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                list.add(resultSetMetaData.getColumnName(column));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    @Override
    public List<String> getTableData(String tableName, Page page) throws BGException {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + page.sqlLimit();
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            ResultSet resultSet = psSelect.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                JSONObject json = new JSONObject();
                for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                    json.put(resultSetMetaData.getColumnName(column), (Object)resultSet.getString(column));
                }
                list.add(json.toString());
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    @Override
    public void dropTables(List<String> tableNames) throws BGException {
        if (this.userId != 1) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f 'admin'");
        }
        Connection con = this.getConnection();
        try {
            for (String tableName : tableNames) {
                ServerUtils.dropExistTable(con, tableName);
                con.commit();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

