/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events;

import bitel.billing.server.contract.bean.AdditionalContractAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;

@XmlRootElement
public class GetAdditionalActionListEvent
extends LocalEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(GetAdditionalActionListEvent.class);
    private List<AdditionalContractAction> actionList = new ArrayList<AdditionalContractAction>();
    private Set<Integer> actionSet = new HashSet<Integer>();

    protected GetAdditionalActionListEvent() {
    }

    public GetAdditionalActionListEvent(int userId, int cid) {
        super(0, cid, userId);
    }

    public List<AdditionalContractAction> getActionList() {
        return this.actionList;
    }

    public List<AdditionalContractAction> getActionListWithDescription() {
        ArrayList<AdditionalContractAction> actionListWithDescription = new ArrayList<AdditionalContractAction>();
        for (AdditionalContractAction action : this.actionList) {
            Object newTitle = action.getTitle();
            String description = action.getDescription();
            if (!Utils.isEmptyString((String)description)) {
                newTitle = (String)newTitle + " [" + description + "]";
            }
            actionListWithDescription.add(new AdditionalContractAction(action.getId(), (String)newTitle, description));
        }
        return actionListWithDescription;
    }

    public void addAction(int id, String title) {
        this.actionList.add(new AdditionalContractAction(id, title));
        this.actionSet.add(id);
    }

    public void addAction(int id, String title, String description) {
        this.actionList.add(new AdditionalContractAction(id, title, description));
        this.actionSet.add(id);
    }

    public boolean actionAllowed(int id) {
        return this.actionSet.contains(id);
    }
}

