/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.dev;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScript;
import ru.bitel.common.Utils;

public abstract class EventScriptBase<E extends Event>
implements EventScript<E> {
    protected PrintStream out;
    protected PrintStream err;

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    public void setErrorStream(PrintStream err) {
        this.err = err;
    }

    protected void print(Object message) {
        this.out.println(message);
    }

    protected void error(Object message) {
        this.err.println(message);
    }

    protected String doExternalScript(E event, List<String> command) {
        String result = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = processBuilder.start();
            JSONObject eventJsonObject = new JSONObject(event);
            OutputStream outputStream = process.getOutputStream();
            outputStream.write(eventJsonObject.toString().getBytes("UTF-8"));
            ByteArrayOutputStream processOutputStream = new ByteArrayOutputStream();
            Utils.flush((InputStream)process.getInputStream(), (OutputStream)processOutputStream);
            result = new String(processOutputStream.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace(this.err);
        }
        this.print("result = " + result);
        if (result != null) {
            block4: for (String line : result.split("\n")) {
                if (!line.startsWith("R:")) continue;
                try {
                    String[] tokens = line.substring(2).split("\t");
                    for (Method method : event.getClass().getMethods()) {
                        if (!method.getName().equals(tokens[0]) || method.getParameterCount() != tokens.length - 1) continue;
                        int index = 1;
                        ArrayList<Object> args = new ArrayList<Object>();
                        for (Parameter parameter : method.getParameters()) {
                            Class<?> clazz = parameter.getType();
                            if (clazz.equals(String.class)) {
                                args.add(String.valueOf(tokens[index]));
                            } else if (clazz.equals(Integer.TYPE)) {
                                args.add(Integer.parseInt(tokens[index]));
                            } else if (clazz.equals(BigDecimal.class)) {
                                args.add(new BigDecimal(tokens[index]));
                            }
                            ++index;
                        }
                        method.invoke(event, args.toArray());
                        continue block4;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(this.err);
                }
            }
        }
        return result;
    }
}

