/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.updater.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTask;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTaskLogStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UpdaterTaskDao
extends AbstractDao<UpdaterTask> {
    public UpdaterTaskDao(Connection con) {
        super(con, 0, "updater_task");
    }

    public void searchUpdaterTaskList(SearchResult<UpdaterTask> searchResult, UpdaterTaskLogStatus status) throws BGException {
        try {
            Page page = searchResult.getPage();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
                searchResult.setPage(page);
            }
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true" + (status != null ? " AND status=?" : "") + page.sqlLimit();
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            int index = 1;
            if (status != null) {
                ps.setString(index++, status.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            ps.close();
            rs.close();
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected UpdaterTask getFromRS(ResultSet rs) throws SQLException, BGException {
        UpdaterTask updaterTask = new UpdaterTask();
        updaterTask.setId(rs.getInt("id"));
        updaterTask.setTaskClass(rs.getString("task_class"));
        updaterTask.setTitle(rs.getString("title"));
        updaterTask.setComment(rs.getString("comment"));
        updaterTask.setRunDate(rs.getTimestamp("run_date"));
        updaterTask.setStatus(UpdaterTaskLogStatus.valueOf(rs.getString("status")));
        return updaterTask;
    }

    protected void updateImpl(UpdaterTask b) throws BGException, SQLException {
    }
}

