/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class WebMenuBase
implements WebMenu {
    @Override
    public final List<MenuItem> getWebMenuItems(Connection con, String module, int moduleId) throws BGException {
        return this.getWebMenuItems(con, module, moduleId, false);
    }

    public List<MenuItem> getWebMenuItems(Connection con, String module, int moduleId, boolean all) throws BGException {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        Preferences pluginSetup = BGPluginManagerServer.getManager().getPlugin(module).getSetup();
        BGPlugInElement extension = BGPluginManagerServer.getManager().getExtension(module, WebMenu.class.getName());
        if (extension != null) {
            for (Element itemElement : XMLUtils.selectElements((Node)extension.getElement(), (String)"item")) {
                MenuItem menuItem = new MenuItem();
                menuItem.setId(Utils.parseInt((String)itemElement.getAttribute("id")));
                String title = itemElement.getAttribute("titleDefault");
                if (!all) {
                    String webMenuItemtitle = pluginSetup.get("web.menuItem" + menuItem.getId(), null);
                    if (webMenuItemtitle != null) {
                        if ("none".equals(webMenuItemtitle)) continue;
                        title = webMenuItemtitle;
                    } else if ("0".equals(itemElement.getAttribute("defaultVisible"))) continue;
                }
                menuItem.setTitle(title);
                menuItem.setModule(module);
                menuItem.setModuleId(moduleId);
                menuItem.setAction(itemElement.getAttribute("action"));
                menuItem.setIcon(itemElement.getAttribute("icon"));
                menuItem.setCssClass(itemElement.getAttribute("cssClass"));
                menuItem.setDescription(itemElement.getAttribute("description"));
                list.add(menuItem);
            }
        }
        return list;
    }

    @Override
    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws BGException {
        return this.getWebMenuItems(con, module, moduleId);
    }

    protected List<MenuItem> disableContractWebMenuItems(List<MenuItem> list, Set<Integer> disableIds) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        if (list != null) {
            for (MenuItem menuItem : list) {
                if (disableIds != null && disableIds.contains(menuItem.getId())) continue;
                menuItems.add(menuItem);
            }
        }
        return menuItems;
    }
}

