/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.run;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import ru.bitel.bgbilling.kernel.application.server.CommandPortListener;

public class Application {
    public static void main(String[] args) throws FileNotFoundException, XPathExpressionException, IllegalArgumentException, ScriptException, InstantiationException, IllegalAccessException, InvocationTargetException, NamingException {
        if (args.length == 0) {
            System.err.println("Error: null arguments. Exit...");
            System.exit(-1);
        }
        int adminPort = -1;
        try {
            adminPort = Integer.parseInt(System.getProperty("admin.port"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (adminPort <= 0) {
            System.err.println("Error: incorrect admin.port. Exit...");
            System.exit(-2);
        }
        try {
            String name = args[0];
            if (args.length > 1) {
                String host = "127.0.0.1";
                String[] cmd = Arrays.copyOfRange(args, 1, args.length);
                CommandPortListener.sendCommand(host, adminPort, cmd);
            } else {
                CommandPortListener commandPortListener = new CommandPortListener(null, adminPort);
                new ru.bitel.bgbilling.kernel.application.server.Application(name, commandPortListener);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

