/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.server.bean.EntitySpecAttrDao;

public class EntitySpecDao
extends AbstractIdDao<EntitySpec>
implements Directory<EntitySpec> {
    private EntitySpecAttrDao esam;

    public EntitySpecDao(Connection con) {
        super(con, 0, "entity_spec");
        this.esam = new EntitySpecAttrDao(con);
    }

    protected EntitySpec getFromRS(ResultSet rs) throws SQLException, BGException {
        int id = rs.getInt("id");
        EntitySpec result = EntitySpec.builder().setId(id).setTitle(rs.getString("title")).setEntitySpecTypeId(rs.getInt("entitySpecTypeId")).setComment(rs.getString("comment")).setHidden(rs.getBoolean("hidden")).setEntityTitleMacros(rs.getString("entityTitleMacros")).setAttributeList(this.esam.listByEntitySpec(id)).build();
        return result;
    }

    protected void updateImpl(EntitySpec entitySpec) throws BGException, SQLException {
        boolean update = entitySpec.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, entitySpecTypeId=?, entityTitleMacros=?, comment=?, hidden=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, entitySpec.getTitle());
            ps.setInt(index++, entitySpec.getEntitySpecTypeId());
            ps.setString(index++, entitySpec.getEntityTitleMacros());
            ps.setString(index++, entitySpec.getComment());
            ps.setBoolean(index++, entitySpec.isHidden());
            if (update) {
                ps.setInt(index++, entitySpec.getId());
            }
            ps.executeUpdate();
            if (!update) {
                entitySpec.setId(ServerUtils.lastInsertId(ps));
            }
            this.esam.update(entitySpec);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        int result = super.deleteImpl(id);
        return result;
    }

    @Override
    public List<EntitySpec> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    @Override
    public EntitySpec get(String title) throws BGException {
        return (EntitySpec)super.get("title=?", new Object[]{title});
    }
}

