/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.job.server;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.kernel.job.server.JobContext;
import ru.bitel.oss.kernel.job.server.JobStore;

public class JobScheduler
implements Runnable,
ThreadContextFactory<JobContext> {
    private static final Logger logger = LogManager.getLogger();
    private final Setup setup;
    private final int moduleId;
    private final JobStore jobStore;
    final ScheduledExecutorService scheduledExecutorService;
    private static final Map<Key, JobScheduler> JOB_EXECUTOR_MAP = new HashMap<Key, JobScheduler>();
    private static AtomicLong count = new AtomicLong();

    JobScheduler(Setup setup, String name, int moduleId, int threadPoolSize) {
        this.setup = setup;
        this.moduleId = moduleId;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(threadPoolSize, (ThreadFactory)new WorkerThreadFactory("job-" + name, "jobExecutor", (ThreadContextFactory)this));
        this.jobStore = new JobStore(setup, this, name, moduleId);
        this.jobStore.load();
        long storeReloadPeriodMillis = this.storeReloadPeriodMillis();
        this.scheduledExecutorService.scheduleWithFixedDelay(this, storeReloadPeriodMillis, storeReloadPeriodMillis, TimeUnit.MILLISECONDS);
    }

    long storeReloadPeriodMillis() {
        return TimeUnit.HOURS.toMillis(1L);
    }

    public static synchronized JobScheduler init(String name, int moduleId, int threadPoolSize) {
        Key key = new Key(name, moduleId);
        JobScheduler result = JOB_EXECUTOR_MAP.get(key);
        if (result != null) {
            return result;
        }
        result = new JobScheduler(Setup.getSetup(), name, moduleId, threadPoolSize);
        JOB_EXECUTOR_MAP.put(key, result);
        return result;
    }

    public static JobScheduler getInstance(String name, int moduleId) {
        return JobScheduler.init(name, moduleId, 24);
    }

    @Override
    public void run() {
        try {
            this.jobStore.load();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    final ScheduledFuture<?> schedule(Runnable jobTriggerRuntime, long delay) {
        return this.scheduledExecutorService.schedule(jobTriggerRuntime, delay, TimeUnit.MILLISECONDS);
    }

    public long schedule(Class<?> clazz, ParameterMap params, Date time) throws BGException {
        return this.jobStore.schedule(clazz, params, time.getTime());
    }

    public long schedule(Class<?> clazz, ParameterMap params, String year, String month, String dayOfMonth, String dayOfWeek, String hour, String minute, String second) throws BGException {
        return this.jobStore.schedule(clazz, params, year, month, dayOfMonth, dayOfWeek, hour, minute, second);
    }

    public void cancel(long jobId) {
        this.jobStore.cancel(jobId);
    }

    public JobContext newThreadContext() {
        return new JobContext(this.setup, this.moduleId);
    }

    public static void main(String[] args) throws BGException {
        Setup setup = new Setup("data.data");
        Setup.setSetup(setup);
        final JobScheduler jobExecutor = JobScheduler.getInstance("tariff_option", 0);
        int cc = 20000;
        int c = 8;
        count.set(20000L);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, 30);
        final Date time = calendar.getTime();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 2500; ++i) {
                        jobExecutor.schedule(MyJob.class, null, time);
                    }
                    System.out.println("OK");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        for (int i = 0; i < 8; ++i) {
            new Thread(r).start();
        }
        System.out.println(123);
    }

    static class Key {
        final String name;
        final int moduleId;

        public Key(String name, int moduleId) {
            this.name = name;
            this.moduleId = moduleId;
        }

        public int hashCode() {
            return 31 * (31 + this.moduleId) + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            if (this.moduleId != other.moduleId) {
                return false;
            }
            return this.name.equals(other.name);
        }
    }

    public static class MyJob
    implements Callable<Object> {
        @Override
        public Object call() throws Exception {
            long cnt = count.decrementAndGet();
            if (cnt % 10L == 0L) {
                logger.debug((Object)cnt);
            }
            return "Hello";
        }
    }
}

