/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;

public class ProductSpecActivationModeDao {
    private final Connection con;
    private final String tableName;

    public ProductSpecActivationModeDao(Connection con, int moduleId) {
        this.con = con;
        this.tableName = moduleId > 0 ? "inv_product_spec_activation_mode_" + moduleId : "inv_product_spec_activation_mode";
    }

    protected ProductSpecActivationMode getFromRS(ResultSet rs) throws SQLException, BGException {
        ProductSpecActivationMode result = new ProductSpecActivationMode();
        result.setId(rs.getInt("id"));
        result.setProductSpecId(rs.getInt("productSpecId"));
        result.setTitle(rs.getString("title"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setPeriodMode(rs.getInt("periodMode"));
        result.setPeriodAmount(rs.getInt("periodAmount"));
        result.setDeactivationMode(rs.getInt("deactivationMode"));
        result.setReactivationMode(rs.getInt("reactivationMode"));
        return result;
    }

    public void update(int productSpecId, List<ProductSpecActivationMode> activationModeList) throws BGException {
        try {
            List<ProductSpecActivationMode> oldList = this.list(productSpecId, null);
            Set newIds = activationModeList == null ? Collections.emptySet() : activationModeList.stream().map(a -> a.getId()).collect(Collectors.toSet());
            Set removeIds = oldList.stream().map(a -> a.getId()).filter(a -> !newIds.contains(a)).collect(Collectors.toSet());
            try (ProductDao productDao = new ProductDao(this.con, 0);){
                for (Integer activationModeId : removeIds) {
                    productDao.checkProductSpecActivationModeDelete(activationModeId);
                }
            }
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (productSpecId, title, dateFrom, dateTo, periodMode, periodAmount, deactivationMode, reactivationMode) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, dateFrom=?, dateTo=?, periodMode=?, periodAmount=?, deactivationMode=?, reactivationMode=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            if (activationModeList != null) {
                for (ProductSpecActivationMode mode : activationModeList) {
                    this.update(productSpecId, mode, insertPS, updatePS);
                    ids.add(mode.getId());
                }
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE productSpecId=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, productSpecId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int productSpecId, ProductSpecActivationMode mode, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        if (mode.getId() > 0) {
            updatePS.setString(1, mode.getTitle());
            updatePS.setDate(2, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            updatePS.setDate(3, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            updatePS.setInt(4, mode.getPeriodMode());
            updatePS.setInt(5, mode.getPeriodAmount());
            updatePS.setInt(6, mode.getDeactivationMode());
            updatePS.setInt(7, mode.getReactivationMode());
            updatePS.setInt(8, mode.getId());
            if (updatePS.executeUpdate() == 0) {
                mode.setId(-1);
            }
        }
        if (mode.getId() <= 0) {
            insertPS.setInt(1, productSpecId);
            insertPS.setString(2, mode.getTitle());
            insertPS.setDate(3, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            insertPS.setDate(4, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            insertPS.setInt(5, mode.getPeriodMode());
            insertPS.setInt(6, mode.getPeriodAmount());
            insertPS.setInt(7, mode.getDeactivationMode());
            insertPS.setInt(8, mode.getReactivationMode());
            insertPS.executeUpdate();
            mode.setId(ServerUtils.lastInsertId(insertPS));
        }
    }

    public List<ProductSpecActivationMode> list(int productSpecId, Date date) throws BGException {
        try {
            ArrayList<ProductSpecActivationMode> result = new ArrayList<ProductSpecActivationMode>();
            String query = "SELECT mode.* FROM " + this.tableName + " AS mode WHERE mode.productSpecId=? ";
            if (date != null) {
                query = query + "AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ?<=dateTo)";
            }
            query = query + "ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, productSpecId);
            if (date != null) {
                java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
                ps.setDate(2, sqlDate);
                ps.setDate(3, sqlDate);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

