/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Node;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanCategory;

public class VlanCategoryDao
extends AbstractIdDao<VlanCategory> {
    public VlanCategoryDao(Connection con, int mid) {
        super(con, mid, "inv_vlan_category");
    }

    protected VlanCategory getFromRS(ResultSet rs) throws SQLException, BGException {
        VlanCategory result = new VlanCategory();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    protected void updateImpl(VlanCategory b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b == null || Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=? WHERE id=?");
            ps.setInt(3, b.getId());
        }
        ps.setInt(1, b.getParentId());
        ps.setString(2, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public VlanCategory root() throws BGException {
        VlanCategory root = new VlanCategory();
        root.setId(0);
        root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 Vlan \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        return (VlanCategory)TreeUtils.tree((List)this.list(null, null, new Object[0]), (Node)root);
    }
}

