/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResourceSubscription;

public class VlanResourceSubscriptionDao
extends AbstractDao<VlanResourceSubscription> {
    private static final Object mutex = new Object();

    public VlanResourceSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_vlan_resource_subscription");
    }

    protected VlanResourceSubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        VlanResourceSubscription result = new VlanResourceSubscription();
        result.setId(rs.getInt("id"));
        result.setVlanResourseId(rs.getInt("vlanResId"));
        result.setVlan(rs.getInt("vlan"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setSubscriberType(rs.getShort("subscriberType"));
        result.setSubscriberId(rs.getInt("subscriberId"));
        result.setSubscriberTitle(rs.getString("subscriberTitle"));
        return result;
    }

    protected void updateImpl(VlanResourceSubscription b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (vlanResId, vlan, dateFrom, dateTo,  subscriberType, subscriberId, subscriberTitle) VALUES (?,?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET vlanResId=?, vlan=?, dateFrom=?, dateTo=?,  subscriberType=?, subscriberId=?, subscriberTitle=? WHERE id=?");
            ps.setInt(8, b.getId());
        }
        ps.setInt(1, b.getVlanResourseId());
        ps.setInt(2, b.getVlan());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setShort(5, b.getSubscriberType());
        ps.setInt(6, b.getSubscriberId());
        ps.setString(7, b.getSubscriberTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public Set<Integer> subscribedVlans(int vlanResourceId, Date dateFrom, Date dateTo) throws BGException {
        try {
            HashSet<Integer> result = new HashSet<Integer>(128);
            PreparedStatement ps = this.con.prepareStatement("SELECT vlan FROM " + this.tableName + " WHERE vlanResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)");
            int idx = 1;
            ps.setInt(idx++, vlanResourceId);
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<VlanResourceSubscription> list(int vlanResourceId, Date dateFrom, Date dateTo) throws BGException {
        return this.list("vlanResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "id", new Object[]{vlanResourceId, dateTo, dateTo, dateFrom, dateFrom});
    }

    public Result<VlanResourceSubscription> list(int vlanResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.list(page, "vlanResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "id", new Object[]{vlanResourceId, dateTo, dateTo, dateFrom, dateFrom});
    }

    @Deprecated
    public int deleteBySubscriberId(int subscriberId) throws BGException {
        return this.delete("subscriberId=? AND subscriberType=1", new Object[]{subscriberId});
    }

    public int deleteBySubscriberId(short subscriberType, int subscriberId) throws BGException {
        return this.delete("subscriberId=? AND subscriberType=?", new Object[]{subscriberId, subscriberType});
    }
}

