/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CalendarPanelNoDay
extends JPanel {
    private static final Font fontBold = new Font("Dialog", 1, 12);
    private static final Font fontPlain = new Font("Dialog", 0, 10);
    private static final Font fontLabel = new Font("Dialog", 0, 9);
    private Calendar calendarOld = null;
    private Calendar calendarCurrent = null;
    private Calendar firstDate = null;
    private JButton buttonMonthDec = new JButton();
    private JButton buttonClear = new JButton();
    private JButton buttonMonthInc = new JButton();
    private JPanel jPanel1 = new JPanel();
    private JPanel panelMonth = new JPanel();
    private JPanel panelYear = new JPanel();
    private JLabel labelDate = new JLabel();
    private DateField dateField = new DateField();
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if ((e.getModifiersEx() & 0x80) > 0) {
                switch (e.getKeyCode()) {
                    case 37: {
                        CalendarPanelNoDay.this.buttonMonthDec_actionPerformed();
                        break;
                    }
                    case 39: {
                        CalendarPanelNoDay.this.buttonMonthInc_actionPerformed();
                        break;
                    }
                    case 38: {
                        CalendarPanelNoDay.this.buttonYearInc_actionPerformed();
                        break;
                    }
                    case 40: {
                        CalendarPanelNoDay.this.buttonYearDec_actionPerformed();
                    }
                }
            } else {
                switch (e.getKeyCode()) {
                    case 27: {
                        CalendarPanelNoDay.this.buttonClear_actionPerformed();
                    }
                }
            }
        }
    };

    public CalendarPanelNoDay() {
        try {
            this.jbInit();
            this.buildButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateDate();
    }

    private void jbInit() throws Exception {
        GridLayout gridLayout = null;
        this.setLayout(new GridBagLayout());
        this.buttonMonthDec.setFont(fontBold);
        this.buttonMonthDec.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMonthDec.setText(" < ");
        this.buttonMonthDec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanelNoDay.this.buttonMonthDec_actionPerformed();
            }
        });
        this.buttonClear.setFont(fontBold);
        this.buttonClear.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClear.setText(" X ");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanelNoDay.this.buttonClear_actionPerformed();
            }
        });
        this.buttonMonthInc.setFont(fontBold);
        this.buttonMonthInc.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMonthInc.setText(" > ");
        this.buttonMonthInc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanelNoDay.this.buttonMonthInc_actionPerformed();
            }
        });
        gridLayout = new GridLayout();
        this.panelMonth.setLayout(gridLayout);
        gridLayout.setRows(7);
        gridLayout.setColumns(2);
        gridLayout = new GridLayout();
        this.panelYear.setLayout(gridLayout);
        gridLayout.setRows(7);
        gridLayout.setColumns(1);
        this.jPanel1.setLayout(new GridBagLayout());
        this.labelDate.setFont(fontBold);
        this.labelDate.setText(" ");
        this.jPanel1.setOpaque(false);
        final JButton ok = new JButton();
        ok.setFont(fontBold);
        ok.setMargin(new Insets(2, 2, 2, 2));
        ok.setText("OK");
        KeyAdapter l = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        ok.doClick();
                        break;
                    }
                    case 27: {
                        ok.doClick();
                    }
                }
            }
        };
        this.dateField.addKeyListener(l);
        this.dateField.addKeyListener(this.keyListener);
        ok.addKeyListener(l);
        ok.addKeyListener(this.keyListener);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String date = CalendarPanelNoDay.this.dateField.getText();
                if (date != null) {
                    CalendarPanelNoDay.this.calendarCurrent = (Calendar)CalendarPanelNoDay.this.firstDate.clone();
                    CalendarPanelNoDay.this.calendarCurrent.setTime(TimeUtils.convertStringToDate(date, "MM.yyyy"));
                    CalendarPanelNoDay.this.updateDate();
                    CalendarPanelNoDay.this.firePropertyChange("updateCalendar", true, false);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.dateField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.buttonMonthDec, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonClear, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.buttonMonthInc, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labelDate, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.panelMonth, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.panelYear, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonMonthInc.addKeyListener(this.keyListener);
        this.buttonMonthDec.addKeyListener(this.keyListener);
        this.buttonClear.addKeyListener(this.keyListener);
    }

    private void buildButtons() {
        JButton button;
        int i;
        JLabel label = null;
        Insets insets = new Insets(0, 0, 0, 0);
        Dimension dimension = new Dimension(26, 20);
        ActionListener mbal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanelNoDay.this.monthClick(e);
            }
        };
        ActionListener ybal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanelNoDay.this.yearClick(e);
            }
        };
        for (i = 0; i < 2; ++i) {
            label = new JLabel(" ");
            label.setFont(fontLabel);
            this.panelMonth.add((Component)label, null);
        }
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setText("0" + String.valueOf(i + 1));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
            button.addKeyListener(this.keyListener);
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i + 6));
            if (i + 7 < 10) {
                button.setText("0" + String.valueOf(i + 7));
            } else {
                button.setText(String.valueOf(i + 7));
            }
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
            button.addKeyListener(this.keyListener);
        }
        label = new JLabel(" ");
        label.setFont(fontLabel);
        this.panelYear.add((Component)label, null);
        dimension = new Dimension(40, 20);
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelYear.add((Component)button, null);
            button.addActionListener(ybal);
        }
        ((JButton)this.panelYear.getComponent(5)).setFont(fontBold);
    }

    private void buttonYearDec_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(1, -1);
        }
        this.updateDate();
    }

    private void buttonYearInc_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(1, 1);
        }
        this.updateDate();
    }

    private void buttonMonthInc_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(2, 1);
        }
        this.updateDate();
    }

    private void buttonMonthDec_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(2, -1);
        }
        this.updateDate();
    }

    private void updateDate() {
        if (this.calendarCurrent == null) {
            return;
        }
        int year = this.calendarCurrent.get(1);
        int month = this.calendarCurrent.get(2);
        GregorianCalendar calendar = new GregorianCalendar(year, month, 1);
        this.firstDate = (Calendar)((Calendar)calendar).clone();
        for (int i = 1; i < this.panelYear.getComponentCount(); ++i) {
            JButton button = (JButton)this.panelYear.getComponent(i);
            button.setActionCommand(String.valueOf(year - 5 + i));
            button.setText(String.valueOf(year - 5 + i));
        }
        String monthString = String.valueOf(month);
        for (int i = 2; i < this.panelMonth.getComponentCount(); ++i) {
            JButton button = (JButton)this.panelMonth.getComponent(i);
            if (monthString.equals(button.getActionCommand())) {
                button.setFont(fontBold);
                continue;
            }
            button.setFont(fontPlain);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.calendarCurrent.get(5));
        buf.append(' ');
        buf.append(TimeUtils.monthNames[month]);
        buf.append(' ');
        buf.append(year);
        this.labelDate.setText(buf.toString());
        SimpleDateFormat f = new SimpleDateFormat("MM.yyyy");
        this.dateField.setText(f.format(this.calendarCurrent.getTime()));
        this.firePropertyChange("updateTitle", "", buf.toString());
    }

    private void monthClick(ActionEvent e) {
        this.calendarCurrent = (Calendar)this.firstDate.clone();
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(2, Utils.parseInt(actionCommand, 0));
        this.updateDate();
        this.firePropertyChange("updateCalendar", true, false);
    }

    private void yearClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(1, Utils.parseInt(actionCommand, 2000));
        this.updateDate();
    }

    public void setCalendar(Calendar calendar) {
        this.calendarOld = calendar;
        this.calendarCurrent = calendar == null ? new GregorianCalendar() : (Calendar)calendar.clone();
        this.calendarCurrent.clear(14);
        this.calendarCurrent.clear(13);
        this.calendarCurrent.clear(12);
        this.calendarCurrent.clear(11);
        this.calendarCurrent.clear(0);
        this.updateDate();
    }

    public Calendar getCalendar() {
        return this.calendarCurrent;
    }

    public Calendar getOldCalendar() {
        return this.calendarOld;
    }

    private void buttonClear_actionPerformed() {
        this.calendarCurrent = null;
        this.labelDate.setText(" ");
        this.firePropertyChange("updateCalendar", true, false);
    }

    public void setVisibleLabelDate(boolean value) {
        this.labelDate.setVisible(value);
    }

    public BGMaskTextField getDateField() {
        return this.dateField;
    }

    private class DateField
    extends BGMaskTextField {
        DateField() {
            super("  .    ", ".", new BGMaskTextField.IntegerValidator(1L, 12L, 2), new BGMaskTextField.IntegerValidator());
            this.setHorizontalAlignment(0);
        }
    }
}

