/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ContractPersonalTariff
extends BGPanel {
    private String module = "contract.tariff";
    private CardLayout cardLayout = new CardLayout();
    private PersonalTariffTableModel tableModel = new PersonalTariffTableModel(PersonalTariffTableModel.class.getName());
    private BGUTable table = new BGUTable(this.tableModel);
    private TariffTree tariffTree = new TariffTree();
    private JPanel tablePanel = new JPanel(new GridBagLayout());
    private JPanel treePanel = new JPanel(new GridBagLayout());
    private final JButton showTree = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
    private PersonalTariffEditor editor = null;
    private Calendar nowDate = new GregorianCalendar();

    public ContractPersonalTariff() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.editor = new PersonalTariffEditor();
        this.showTree.addActionListener(e -> this.openTree());
        this.tablePanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tablePanel.add((Component)this.showTree, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePanel.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton showTable = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
        showTable.addActionListener(e -> this.openTable());
        this.treePanel.add(this.tariffTree.getViewable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.treePanel.add((Component)showTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)this.tablePanel, "table");
        this.add((Component)this.treePanel, "tree");
        this.cardLayout.show(this, "table");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractPersonalTariff.this.editItem();
                }
            }
        });
    }

    @Override
    public void setData() {
        if (this.tablePanel.isVisible()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("PersonalTariffTable");
            request.setContractId(this.getContractId());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                ArrayList data = new ArrayList();
                XMLUtils.selectElements(doc, "//table/data/row").forEach(e -> data.add(e));
                this.tableModel.setData(data);
            }
        }
    }

    @Override
    public void newItem() {
        if (this.tablePanel.isVisible()) {
            this.id = "0";
            this.startEdit();
        }
    }

    @Override
    public void editItem() {
        Element element;
        if (this.tablePanel.isVisible() && (element = (Element)this.tableModel.getSelectedRow()) != null) {
            this.id = element.getAttribute("id");
            this.startEdit();
        }
    }

    @Override
    public void deleteItem() {
        Element element;
        if (this.tablePanel.isVisible() && (element = (Element)this.tableModel.getSelectedRow()) != null && ClientUtils.confirmDelete("\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 [#" + element.getAttribute("id") + "]")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeletePersonalTariff");
            request.setAttribute("id", element.getAttribute("id"));
            request.setContractId(this.getContractId());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            }
        }
    }

    private void startEdit() {
        if (this.id.equals("0")) {
            this.editor.title.setText("");
            this.editor.titleWeb.setText("");
            String nowDateStr = TimeUtils.format(this.nowDate, "dd.MM.yyyy");
            this.editor.date1.setDateString(nowDateStr);
            this.editor.date2.setDateString("");
            this.editor.config.setText("");
        } else {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetPersonalTariff");
            request.setAttribute("id", this.id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element tariff = XMLUtils.selectElement(doc, "//tariff");
                this.editor.title.setText(XMLUtils.getAttribute(tariff, "title", "\u0411\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f ;-(("));
                this.editor.titleWeb.setText(XMLUtils.getAttribute(tariff, "titleWeb", this.editor.titleWeb.getText()));
                this.editor.date1.setDateString(tariff.getAttribute("date1"));
                this.editor.date2.setDateString(tariff.getAttribute("date2"));
                this.editor.pos.setText(tariff.getAttribute("pos"));
                this.editor.config.setText(XMLUtils.getAttribute(tariff, "config"));
            }
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            String title = this.editor.title.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAttribute("id", this.id);
            request.setContractId(this.getContractId());
            request.setAction("UpdatePersonalTariff");
            request.setAttribute("title", title);
            if (this.editor.date1.getDateString().isEmpty()) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            request.setAttribute("date1", this.editor.date1.getDateString());
            request.setAttribute("date2", this.editor.date2.getDateString());
            request.setAttribute("pos", this.editor.pos.getText());
            request.setAttribute("config", this.editor.config.getText());
            request.setAttribute("title_web", this.editor.titleWeb.getText());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.editor.setVisible(false);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void openTree() {
        Element element = (Element)this.tableModel.getSelectedRow();
        if (element != null) {
            String treeId = element.getAttribute("tree_id");
            this.tariffTree.init(this, Utils.parseInt(treeId, 0));
            this.cardLayout.show(this, "tree");
        } else {
            ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        }
    }

    private void openTable() {
        this.tariffTree.close();
        this.cardLayout.show(this, "table");
    }

    class PersonalTariffTableModel
    extends BGTableModel<Element> {
        public PersonalTariffTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", 100, 100, 100, "pos", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 200, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class PersonalTariffEditor
    extends JPanel {
        private BGTextField title;
        private BGControlPanelDateNoB date1;
        private BGControlPanelDateNoB date2;
        private IntTextField pos;
        private BGTextField titleWeb;
        private BGConfigEditorPane config;

        public PersonalTariffEditor() {
            super(new GridBagLayout());
            this.title = new BGTextField(10);
            this.date1 = new BGControlPanelDateNoB();
            this.date2 = new BGControlPanelDateNoB();
            this.pos = new IntTextField(5);
            this.titleWeb = new BGTextField(10);
            this.config = new BGConfigEditorPane();
            this.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.setVisible(false);
            int gridy = 0;
            JPanel name = new JPanel(new GridBagLayout());
            name.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            name.add((Component)this.title, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            name.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            name.add((Component)this.titleWeb, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            JScrollPane scroll = new JScrollPane(this.config);
            scroll.setPreferredSize(new Dimension(800, 200));
            scroll.setBorder(new CompoundBorder(new BGTitleBorder("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f"), new EmptyBorder(2, 5, 5, 5)));
            JPanel left = new JPanel(new GridBagLayout());
            left.add((Component)this.getPosPeriodPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            left.add((Component)name, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            left.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            JPanel top = new JPanel(new GridBagLayout());
            top.add((Component)left, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            top.add((Component)scroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> ContractPersonalTariff.this.stopEdit(e.getActionCommand().equals("ok")));
            this.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)okCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    ContractPersonalTariff.this.showTree.setVisible(false);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ContractPersonalTariff.this.showTree.setVisible(true);
                }
            });
        }

        private JPanel getPosPeriodPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.pos, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("   \u041f\u0435\u0440\u0438\u043e\u0434: \u0441 "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.date1, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" \u043f\u043e "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.date2, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }
    }
}

