/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGBorderFactory;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.ParameterEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class MultiListParamEditor
extends ParameterEditor {
    protected JTextField customValueField = new JTextField();
    protected BGControlPanelListSelect valuesList = new BGControlPanelListSelect();
    protected JCheckBox customValueCheckBox = new JCheckBox("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (\u0447\u0435\u0440\u0435\u0437 \";\" ):");

    public MultiListParamEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.valuesList.setBorder(BGBorderFactory.createEmptyBorder());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.valuesList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.customValueCheckBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.customValueField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.customValueField.setEnabled(false);
        this.customValueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiListParamEditor.this.customValueField.setEnabled(!MultiListParamEditor.this.customValueField.isEnabled());
            }
        });
    }

    @Override
    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GetMultiListParam");
        req.setContractId(this.getContractId());
        req.setAttribute("pid", this.getId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            Element values = XMLUtils.selectElement(doc, "//values");
            String currentValue = values.getAttribute("value");
            ClientUtils.buildMultiList(this.valuesList.getList(), this.valuesList.getListModel(), values, Arrays.asList(currentValue.split(";")));
            this.customValueField.setText(values.getAttribute("custom_value"));
            if (!Utils.isEmptyString(this.customValueField.getText())) {
                this.customValueCheckBox.setSelected(true);
                this.customValueField.setEnabled(true);
            } else {
                this.customValueCheckBox.setSelected(false);
                this.customValueField.setEnabled(false);
            }
        }
    }

    @Override
    public boolean updateData() {
        boolean result = false;
        Request req = new Request();
        req.setModule(this.module);
        req.setAttribute("pid", this.getId());
        ListModel<ListItem> li = this.valuesList.getList().getModel();
        req.setAction("UpdateMultiListParam");
        req.setAttribute("cid", this.getContractId());
        MultiListParamValues listValues = new MultiListParamValues();
        if (this.customValueCheckBox.isSelected() & this.customValueField.getText().equals("")) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
            return false;
        }
        if (li != null) {
            for (int i = 0; i < li.getSize(); ++i) {
                ListItem item = li.getElementAt(i);
                if (!item.isSelected()) continue;
                ListParamValue paramValue = new ListParamValue();
                paramValue.setId(Utils.parseInt((String)item.getAttribute("id")));
                paramValue.setValue((String)item.getAttribute("title"));
                listValues.add(paramValue);
            }
        }
        if (this.customValueField.isEnabled()) {
            listValues.parseCustomValue(this.customValueField.getText());
        }
        req.setAttribute("value", listValues.getIdValue());
        req.setAttribute("customValue", listValues.getCustomValue());
        this.customValueField.setText("");
        result = ClientUtils.checkStatus(this.getDocument(req));
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        return result;
    }
}

