/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class BGClientSearchResultPopup
extends JPopupMenu {
    private String lastSearchText = "";
    private Color bgColor;
    private Color bgSelectColor;
    private ClientContext clientContext;
    private JPanel selectedPanel;
    private JPanel prefPanel;
    private boolean[] prefCheckBox = new boolean[5];
    private JPanel panel = new JPanel(new GridBagLayout());

    public BGClientSearchResultPopup(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.bgColor = new Color(((ColorUIResource)UIManager.getDefaults().getColor("TextField.background")).getRGB());
        this.bgSelectColor = new Color(((ColorUIResource)UIManager.getDefaults().getColor("List.selectionBackground")).getRGB());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                block3: {
                    block6: {
                        block4: {
                            block5: {
                                if (keyEvent.getKeyCode() != 38) break block4;
                                if (BGClientSearchResultPopup.this.selectedPanel != null) break block5;
                                if (BGClientSearchResultPopup.this.panel.getComponentCount() <= 1) break block3;
                                BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panel.getComponents()[BGClientSearchResultPopup.this.panel.getComponentCount() - 2]);
                                break block3;
                            }
                            if (BGClientSearchResultPopup.this.panel.getComponentCount() <= 1) break block3;
                            for (int index = 0; index < BGClientSearchResultPopup.this.panel.getComponentCount() - 1; ++index) {
                                JPanel testPanel = (JPanel)BGClientSearchResultPopup.this.panel.getComponents()[index];
                                if (BGClientSearchResultPopup.this.selectedPanel != testPanel) continue;
                                BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panel.getComponents()[index > 0 ? index - 1 : BGClientSearchResultPopup.this.panel.getComponentCount() - 2]);
                                break block3;
                            }
                            break block3;
                        }
                        if (keyEvent.getKeyCode() != 40) break block3;
                        if (BGClientSearchResultPopup.this.selectedPanel != null) break block6;
                        if (BGClientSearchResultPopup.this.panel.getComponentCount() <= 1) break block3;
                        BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panel.getComponents()[0]);
                        break block3;
                    }
                    if (BGClientSearchResultPopup.this.panel.getComponentCount() > 1) {
                        for (int index = 0; index < BGClientSearchResultPopup.this.panel.getComponentCount() - 1; ++index) {
                            JPanel testPanel = (JPanel)BGClientSearchResultPopup.this.panel.getComponents()[index];
                            if (BGClientSearchResultPopup.this.selectedPanel != testPanel) continue;
                            BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panel.getComponents()[index < BGClientSearchResultPopup.this.panel.getComponentCount() - 2 ? index + 1 : 0]);
                            break;
                        }
                    }
                }
            }
        });
        Dimension dimension = BGClient.getFrame().getSize();
        JScrollPane scrollPane = new JScrollPane(this.panel);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), new BGTitleBorder("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043e\u0438\u0441\u043a\u0430")));
        this.setLayout(new BorderLayout());
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(dimension.width - 800, dimension.height - 200));
        this.add("Center", scrollPane);
        this.add("West", this.getPrefPanel());
    }

    public void doSearch(String searchText) {
        if (this.lastSearchText.equals(searchText)) {
            return;
        }
        this.lastSearchText = searchText;
        this.doSearch();
    }

    public void doSearch() {
        this.selectedPanel = null;
        this.panel.setBackground(this.bgColor);
        this.panel.removeAll();
        Holder pageHolder = new Holder();
        try {
            ActionListener openContractActionListener = e -> BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt(e.getActionCommand()));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    BGClientSearchResultPopup.this.selectPanel((JPanel)e.getComponent());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        BGClientSearchResultPopup.this.selectedPanel = (JPanel)e.getComponent();
                        BGClientSearchResultPopup.this.openSelectedPanel();
                    }
                }
            };
            List<Contract> contracts = this.clientContext.getPort(ContractService.class).contractList0(0, this.lastSearchText, null, -1, null, null, this.prefCheckBox[3], !this.prefCheckBox[4], this.prefCheckBox[2], (Holder<Page>)pageHolder);
            for (Contract contract : contracts) {
                JButton button = new JButton("\u043e\u0442\u043a\u0440\u044b\u0442\u044c");
                button.addActionListener(openContractActionListener);
                button.setActionCommand(String.valueOf(contract.getId()));
                JPanel resultItemPanel = new JPanel(new GridBagLayout());
                resultItemPanel.setName(String.valueOf(contract.getId()));
                resultItemPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
                resultItemPanel.setOpaque(false);
                resultItemPanel.setPreferredSize(new Dimension(300, 40));
                resultItemPanel.setMaximumSize(new Dimension(300, 100));
                resultItemPanel.addMouseListener(mouseAdapter);
                resultItemPanel.add((Component)new ContractTitleLabel(contract.getTitle()), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                resultItemPanel.add((Component)new ContractCommentLabel(contract.getComment().isEmpty() ? "" : contract.getComment()), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                resultItemPanel.add((Component)button, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)resultItemPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (BGException e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private JPanel getPrefPanel() {
        if (this.prefPanel == null) {
            ActionListener actionListener = e -> {
                this.prefCheckBox[Utils.parseInt((String)e.getActionCommand())] = ((PrefCheckBox)e.getSource()).isSelected();
                this.doSearch();
            };
            String configurationString = ClientSetup.getInstance().get("dbinfo.contract.searchDefaultFilters", "");
            PrefCheckBox hidden = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435", "2", actionListener, configurationString);
            PrefCheckBox subContract = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0440\u0430", "3", actionListener, configurationString);
            PrefCheckBox closed = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435", "4", actionListener, configurationString);
            Dimension dimension = new Dimension(300, 100);
            this.prefPanel = new JPanel(new GridBagLayout());
            this.prefPanel.setOpaque(false);
            this.prefPanel.setMinimumSize(dimension);
            this.prefPanel.setPreferredSize(dimension);
            this.prefPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0), new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u0430")));
            this.prefPanel.add((Component)hidden, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add((Component)subContract, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add((Component)closed, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.prefPanel;
    }

    private void selectPanel(JPanel newSelectedPanel) {
        if (this.selectedPanel != null) {
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.repaint();
        }
        this.selectedPanel = newSelectedPanel;
        this.selectedPanel.setOpaque(true);
        this.selectedPanel.setBackground(this.bgSelectColor);
        this.selectedPanel.repaint();
    }

    public void openSelectedPanel() {
        if (this.selectedPanel != null) {
            BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt(this.selectedPanel.getName()));
            this.setVisible(false);
        }
    }

    public void clearSelectedPanel() {
        this.selectedPanel = null;
        this.setVisible(false);
    }

    class ContractTitleLabel
    extends JLabel {
        public ContractTitleLabel(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(1, 16.0f));
        }
    }

    class ContractCommentLabel
    extends JLabel {
        public ContractCommentLabel(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(2, 12.0f));
        }
    }

    class PrefCheckBox
    extends JCheckBox {
        public PrefCheckBox(String title, String actionCommand, ActionListener actionListener, String configurationString) {
            super(title);
            this.setOpaque(false);
            this.setActionCommand(actionCommand);
            this.setSelected(configurationString.contains(actionCommand));
            this.addActionListener(actionListener);
            BGClientSearchResultPopup.this.prefCheckBox[Utils.parseInt((String)actionCommand)] = this.isSelected();
        }
    }
}

