/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardRemove;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="telegramWebhook", urlPatterns={"/telegramWebhook/*"})
public class TelegramWebhook
extends HttpServlet {
    private Logger logger = LogManager.getLogger();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Setup setup = Setup.getSetup();
            String url = URLEncoder.encode(setup.get("telegram.webhook.url"), "UTF-8");
            if (url != null) {
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.telegram.org/bot" + setup.get("telegram.webhook.token", "X:Y") + "/setWebhook?url=" + url)).build();
                this.logger.info(httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.logger.info(httpServletRequest.getPathInfo());
        httpServletResponse.setStatus(200);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletInputStream inputStream = httpServletRequest.getInputStream();
        byte[] bytes = Utils.readByBlock((InputStream)inputStream);
        String body = new String(bytes, "UTF-8");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("body = " + body);
        }
        String chatId = null;
        JSONObject jsonBody = new JSONObject(body);
        JSONObject messageObject = jsonBody.optJSONObject("message");
        JSONObject callbackQueryObject = jsonBody.optJSONObject("callback_query");
        if (messageObject != null) {
            if (this.logger.isDebugEnabled()) {
                for (String key : messageObject.keySet()) {
                    this.logger.debug(key + " = " + messageObject.optString(key));
                }
            }
            chatId = String.valueOf(messageObject.optQuery("/chat/id"));
            String text = messageObject.optString("text");
            if (text != null && text.startsWith("/")) {
                int pos = text.indexOf(32);
                String command = text.substring(1, pos == -1 ? text.length() : pos);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("command = " + command);
                }
            }
        } else if (callbackQueryObject != null) {
            chatId = String.valueOf(callbackQueryObject.optQuery("/message/chat/id"));
        }
        InlineKeyboardButton inlineKeyboardButton1 = new InlineKeyboardButton("B1");
        inlineKeyboardButton1.setCallbackData("CallbackData");
        ArrayList<InlineKeyboardButton> buttonRow1 = new ArrayList<InlineKeyboardButton>();
        buttonRow1.add(inlineKeyboardButton1);
        ArrayList<ArrayList<InlineKeyboardButton>> keyboard = new ArrayList<ArrayList<InlineKeyboardButton>>();
        keyboard.add(buttonRow1);
        InlineKeyboardMarkup inlineKeyboardMarkup = new InlineKeyboardMarkup();
        inlineKeyboardMarkup.setKeyboard(keyboard);
        SendMessage sendMessage = new SendMessage();
        sendMessage.setChatId(chatId);
        sendMessage.setText("\u041f\u0440\u043e\u0441\u0442\u043e \u0442\u0435\u0441\u0442");
        sendMessage.setReplyMarkup((ReplyKeyboard)this.getReplyKeyboardMarkup());
        ObjectMapper mapper = new ObjectMapper();
        String responseData = mapper.writeValueAsString((Object)sendMessage);
        this.logger.debug("message = " + responseData);
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Content-Type", "application/json");
        ServletOutputStream outputStream = httpServletResponse.getOutputStream();
        outputStream.write(responseData.getBytes("UTF-8"));
        outputStream.flush();
    }

    private ReplyKeyboardMarkup getReplyKeyboardMarkup() {
        KeyboardButton keyboardBalanceButton = new KeyboardButton("\u0411\u0430\u043b\u0430\u043d\u0441");
        KeyboardButton keyboardHelpdeskButton = new KeyboardButton("\u0422\u0435\u0445\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430");
        KeyboardButton keyboardTariffButton = new KeyboardButton("\u0422\u0430\u0440\u0438\u0444");
        KeyboardButton keyboardTariffOptionButton = new KeyboardButton("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438");
        KeyboardButton keyboardLimitButton = new KeyboardButton("\u041b\u0438\u043c\u0438\u0442");
        KeyboardButton keyboardStatusButton = new KeyboardButton("\u0421\u0442\u0430\u0442\u0443\u0441");
        KeyboardRow keyboardRow1 = new KeyboardRow();
        keyboardRow1.add((Object)keyboardBalanceButton);
        keyboardRow1.add((Object)keyboardHelpdeskButton);
        KeyboardRow keyboardRow2 = new KeyboardRow();
        keyboardRow2.add((Object)keyboardTariffButton);
        keyboardRow2.add((Object)keyboardTariffOptionButton);
        KeyboardRow keyboardRow3 = new KeyboardRow();
        keyboardRow3.add((Object)keyboardLimitButton);
        keyboardRow3.add((Object)keyboardStatusButton);
        ArrayList<KeyboardRow> keyboardRows = new ArrayList<KeyboardRow>();
        keyboardRows.add(keyboardRow1);
        keyboardRows.add(keyboardRow2);
        keyboardRows.add(keyboardRow3);
        ReplyKeyboardMarkup replyKeyboardMarkup = new ReplyKeyboardMarkup();
        replyKeyboardMarkup.setResizeKeyboard(Boolean.valueOf(true));
        replyKeyboardMarkup.setOneTimeKeyboard(Boolean.valueOf(false));
        replyKeyboardMarkup.setKeyboard(keyboardRows);
        return replyKeyboardMarkup;
    }

    private ReplyKeyboardRemove getReplyKeyboardRemove() {
        return new ReplyKeyboardRemove();
    }
}

