/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.InstanceResolverAnnotation;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.util.exception.JAXWSExceptionBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.container.ws.server.ServletContainer;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.common.Utils;
import ru.bitel.common.util.Pool;

public abstract class JaxWSAdapter {
    private static final Logger logger = LogManager.getLogger();
    protected final ServletContext servletContext;
    protected final ServletContainer servletContainer;

    public JaxWSAdapter(ServletContext context) {
        this.servletContext = context;
        this.servletContainer = new ServletContainer(context);
    }

    protected abstract ServletAdapter getTarget(String var1, HttpServletRequest var2);

    protected abstract ModuleKey getModuleKey(String var1);

    protected <T> InstanceResolver<T> createInstanceResolver(Class<T> clazz) {
        return InstanceResolver.createDefault(clazz);
    }

    protected static <T> InstanceResolver<T> createFromInstanceResolverAnnotation(Class<T> clazz) {
        for (Annotation a : clazz.getAnnotations()) {
            InstanceResolverAnnotation ira = a.annotationType().getAnnotation(InstanceResolverAnnotation.class);
            if (ira == null) continue;
            Class ir = ira.value();
            try {
                return (InstanceResolver)ir.getConstructor(Class.class).newInstance(clazz);
            }
            catch (InstantiationException e) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER((Object)ir.getName(), a.annotationType(), (Object)clazz.getName()));
            }
            catch (IllegalAccessException e) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER((Object)ir.getName(), a.annotationType(), (Object)clazz.getName()));
            }
            catch (InvocationTargetException e) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER((Object)ir.getName(), a.annotationType(), (Object)clazz.getName()));
            }
            catch (NoSuchMethodException e) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER((Object)ir.getName(), a.annotationType(), (Object)clazz.getName()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSEndpoint<?> createWsEndpoint(Class<?> implementorClass) {
        QName portName;
        QName serviceName;
        SDDocumentSource primaryWSDL;
        block19: {
            EndpointFactory.verifyImplementorClass(implementorClass);
            primaryWSDL = null;
            String wsdlLocation = null;
            serviceName = null;
            portName = null;
            for (Class<?> clazz : implementorClass.getInterfaces()) {
                WebService service = clazz.getAnnotation(WebService.class);
                if (service == null) continue;
                String s = service.serviceName();
                String n = service.targetNamespace();
                wsdlLocation = service.wsdlLocation();
                if (s == null || "".equals(s)) {
                    s = clazz.getSimpleName();
                }
                if (n == null || "".equals(n)) {
                    n = clazz.getPackage() != null ? RuntimeModeler.getNamespace((String)clazz.getPackage().getName()) : RuntimeModeler.getNamespace((String)clazz.getName().substring(0, clazz.getName().lastIndexOf(46)));
                }
                serviceName = new QName(n, s);
                String p = service.portName();
                if (p == null || "".equals(p)) {
                    p = clazz.getSimpleName();
                }
                portName = new QName(n, p);
            }
            try {
                URL url;
                block20: {
                    if (!Utils.notBlankString(wsdlLocation)) break block19;
                    try {
                        url = new URL(wsdlLocation);
                    }
                    catch (MalformedURLException ex) {
                        url = this.getClass().getResource(wsdlLocation);
                        if (url != null) break block20;
                        throw ex;
                    }
                }
                primaryWSDL = SDDocumentSource.create((URL)url);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (serviceName == null) {
            serviceName = EndpointFactory.getDefaultServiceName(implementorClass);
        }
        if (portName == null) {
            portName = EndpointFactory.getDefaultPortName((QName)serviceName, implementorClass);
        }
        String enableMtom = null;
        String mtomThreshold = null;
        MTOM mtom = implementorClass.getAnnotation(MTOM.class);
        if (mtom == null) {
            Class<?> iface;
            Class<?>[] classArray = implementorClass.getInterfaces();
            int service = classArray.length;
            for (int s = 0; s < service && (mtom = (iface = classArray[s]).getAnnotation(MTOM.class)) == null; ++s) {
            }
        }
        if (mtom != null) {
            enableMtom = Boolean.toString(mtom.enabled());
            mtomThreshold = String.valueOf(mtom.threshold());
        }
        WSBinding wSBinding = JaxWSAdapter.createBinding(implementorClass, enableMtom, mtomThreshold);
        boolean handlersSetInDD = this.setHandlersAndRoles(wSBinding);
        Thread currentThread = Thread.currentThread();
        ClassLoader parentClassLoader = currentThread.getContextClassLoader();
        ClassLoader classLoader = this.getClassLoader(parentClassLoader);
        if (classLoader == null && implementorClass.getClassLoader() instanceof DatabaseClassLoader) {
            classLoader = implementorClass.getClassLoader();
        }
        if (classLoader != null) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            Invoker invoker = this.createInstanceResolver(implementorClass).createInvoker();
            WSEndpoint wSEndpoint = WSEndpoint.create(implementorClass, (!handlersSetInDD ? 1 : 0) != 0, (Invoker)invoker, (QName)serviceName, (QName)portName, (Container)this.servletContainer, (WSBinding)wSBinding, (SDDocumentSource)primaryWSDL, Collections.emptySet(), (URL)null);
            return wSEndpoint;
        }
        finally {
            if (classLoader != null) {
                currentThread.setContextClassLoader(parentClassLoader);
            }
        }
    }

    protected ClassLoader getClassLoader(ClassLoader parentClassLoader) {
        return null;
    }

    private static WSBinding createBinding(Class<?> implClass, String mtomEnabled, String mtomThreshold) {
        MTOMFeature mtomfeature = null;
        if (mtomEnabled != null) {
            mtomfeature = mtomThreshold != null ? new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue(), Integer.valueOf(mtomThreshold).intValue()) : new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue());
        }
        BindingID bindingID = BindingID.parse(implClass);
        WebServiceFeatureList features = new WebServiceFeatureList();
        if (mtomfeature != null) {
            features.add((WebServiceFeature)mtomfeature);
        }
        features.addAll((Iterable)bindingID.createBuiltinFeatureList());
        return bindingID.createBinding(features.toArray());
    }

    public boolean handle(HttpServletRequest request, HttpServletResponse response) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            block7: {
                try {
                    try {
                        ServletAdapter target = this.getTarget(pathInfo, request);
                        if (target != null) {
                            target.handle(this.servletContext, request, response);
                            break block7;
                        }
                        response.setStatus(404);
                        response.sendError(404);
                    }
                    catch (JAXWSExceptionBase e) {
                        response.setStatus(500);
                        response.sendError(500);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                        response.setStatus(500);
                        response.sendError(500);
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public boolean handlePut(HttpServletRequest request, HttpServletResponse response) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            try {
                ServletAdapter target = this.getTarget(pathInfo, request);
                if (target != null) {
                    WSBinding binding = target.getEndpoint().getBinding();
                    if (binding instanceof HTTPBinding) {
                        target.handle(this.servletContext, request, response);
                    } else {
                        response.setStatus(405);
                    }
                } else {
                    response.setStatus(404);
                }
            }
            catch (JAXWSExceptionBase e) {
                response.setStatus(500);
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                response.setStatus(500);
                logger.error(e.getMessage(), e);
            }
            return true;
        }
        return false;
    }

    protected boolean setHandlersAndRoles(WSBinding binding) {
        ArrayList<Handler> list = new ArrayList<Handler>();
        this.setHandlers(list);
        binding.setHandlerChain(list);
        return true;
    }

    protected void setHandlers(List<Handler> list) {
        list.add((Handler)new LoggingSOAPHandler());
    }

    protected boolean isLoggingEnabled() {
        return false;
    }

    class LoggingSOAPHandler
    implements SOAPHandler<SOAPMessageContext> {
        private final Pool<ByteArrayOutputStream> baosPool = new Pool<ByteArrayOutputStream>(){

            @Override
            protected ByteArrayOutputStream create() {
                return new ByteArrayOutputStream(1000);
            }

            @Override
            public void recycle(ByteArrayOutputStream t) {
                t.reset();
                super.recycle(t);
            }
        };
        private final Pool<StringBuilder> sbPool = new Pool<StringBuilder>(){

            @Override
            protected StringBuilder create() {
                return new StringBuilder(100);
            }

            @Override
            public void recycle(StringBuilder t) {
                t.setLength(0);
                super.recycle(t);
            }
        };

        LoggingSOAPHandler() {
        }

        public Set<QName> getHeaders() {
            return null;
        }

        public void close(MessageContext context) {
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public boolean handleMessage(SOAPMessageContext context) {
            if (!JaxWSAdapter.this.isLoggingEnabled()) {
                return true;
            }
            try {
                boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
                StringBuilder sb = this.sbPool.take();
                if (outbound) {
                    if (context.getMessage().countAttachments() == 0) {
                        ByteArrayOutputStream out = this.baosPool.take();
                        context.getMessage().writeTo((OutputStream)out);
                        sb.append("<- ").append(new String(out.toByteArray()));
                        this.baosPool.recycle(out);
                    }
                } else {
                    QName operation = (QName)context.get((Object)"javax.xml.ws.wsdl.operation");
                    QName service = (QName)context.get((Object)"javax.xml.ws.wsdl.service");
                    sb.append("-> ").append(service).append((String)(operation != null ? ":" + operation.getLocalPart() : "")).append('\n');
                    if (!(context.getMessage().countAttachments() != 0 || operation != null && operation.getLocalPart().contains("File"))) {
                        ByteArrayOutputStream out = this.baosPool.take();
                        context.getMessage().writeTo((OutputStream)out);
                        sb.append(new String(out.toByteArray()));
                        this.baosPool.recycle(out);
                    }
                }
                logger.info(sb.toString());
                this.sbPool.recycle(sb);
            }
            catch (SOAPException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }
}

