/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.bean.Writable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleServicePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class PatternModuleTabPanel
extends PatternBaseTabPanel {
    private static String NOT_PANEL = "not";
    private Collection<PatternModuleTabPanelItem> moduleTabPanelItems = new ArrayList<PatternModuleTabPanelItem>();
    private Collection<PatternModuleServicePanel> serviceModuleTabPanelItems = new ArrayList<PatternModuleServicePanel>();
    private JPanel tabbed = new JPanel();
    private CardLayout tabbedLayout = new CardLayout();
    private JList<IdTitle> moduleList = new JList(new DefaultListModel());
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> avaliableModuleCombo = new BGComboBox();
    private List<IdTitle> allModulesMap = new ArrayList<IdTitle>();
    private Set<Integer> modulesList = new HashSet<Integer>();
    private BGDialogToolBar propertyToolBar = new BGDialogToolBar();

    public PatternModuleTabPanel(Document moduleDoc) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbed.setLayout(this.tabbedLayout);
        this.tabbed.add((Component)panel1, NOT_PANEL);
        this.loadModules();
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getModulePanel(), (Component)this.tabbed, 250L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JPanel getModulePanel() {
        JPanel modulePanel = new JPanel();
        modulePanel.setLayout(new GridBagLayout());
        modulePanel.add((Component)this.propertyToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        modulePanel.add((Component)new JScrollPane(this.moduleList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        modulePanel.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.propertyToolBar.setOrientation(0);
        this.propertyToolBar.setMargin(new Insets(5, 5, 0, 5));
        this.propertyToolBar.setBorderPainted(false);
        this.propertyToolBar.setFloatable(false);
        this.moduleList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.showConfigPanel();
            }
        });
        this.propertyToolBar.setDefaultButtons(e -> {
            if ("newItem".equals(e.getActionCommand())) {
                this.newItem();
            } else if ("deleteItem".equals(e.getActionCommand())) {
                this.deleteItem();
            }
        });
        this.propertyToolBar.setToolBar(new String[]{"newItem", "deleteItem"});
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add(this.avaliableModuleCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        okCancel.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.stopEdit();
            } else {
                this.editor.setVisible(false);
            }
        });
        this.editor.setVisible(false);
        return modulePanel;
    }

    private void stopEdit() {
        String id = ClientUtils.getIdFromComboBox(this.avaliableModuleCombo);
        if (Utils.notBlankString(id)) {
            int moduleId = Utils.parseInt(id);
            this.modulesList.add(moduleId);
            for (PatternModuleTabPanelItem i : this.moduleTabPanelItems) {
                if (i.getModuleId() != moduleId) continue;
                i.reset();
                break;
            }
            this.rebuildList();
        }
        this.editor.setVisible(false);
    }

    private void rebuildList() {
        DefaultListModel model = (DefaultListModel)this.moduleList.getModel();
        model.removeAllElements();
        for (IdTitle module : this.allModulesMap) {
            if (!this.modulesList.contains(module.getId())) continue;
            model.addElement(module);
        }
        this.showConfigPanel();
    }

    @Override
    public void newItem() {
        this.avaliableModuleCombo.removeAllItems();
        for (IdTitle module : this.allModulesMap) {
            if (this.modulesList.contains(module.getId())) continue;
            this.avaliableModuleCombo.addItem(new ComboBoxItem(module.getId(), module.getTitle()));
        }
        this.editor.setVisible(true);
    }

    @Override
    public void deleteItem() {
        IdTitle item = this.moduleList.getSelectedValue();
        if (item != null) {
            int id = item.getId();
            if (ClientUtils.confirm("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f")) {
                this.modulesList.remove(id);
                this.rebuildList();
            }
        }
        this.setData();
    }

    public void loadModules() {
        HashMap<String, Element> cache = new HashMap<String, Element>();
        this.allModulesMap.clear();
        Request request = new Request();
        request.setModule("service");
        request.setAction("GetModules");
        Document doc = this.getDocument(request);
        Element data = XMLUtils.selectElement(doc, "//table/data");
        NodeList nodeList = data.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Class<?> clazz2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            String mid = el.getAttribute("f0");
            String title = el.getAttribute("f1");
            String pkg = el.getAttribute("f4");
            int m = Utils.parseInt(mid, -1);
            IdTitle module = new IdTitle(m, title);
            this.allModulesMap.add(module);
            JTabbedPane panel = new JTabbedPane();
            panel.setVisible(false);
            boolean add = false;
            try {
                clazz2 = Class.forName(pkg + ".PatternModuleTabPanelItemFactory");
                if (clazz2 != null && PatternModuleTabPanelItemFactory.class.isAssignableFrom(clazz2)) {
                    PatternModuleTabPanelItemFactory f = (PatternModuleTabPanelItemFactory)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (PatternModuleTabPanelItem o : f.getPatternModuleTabPanelItems(m, title)) {
                        this.moduleTabPanelItems.add(o.init(cache, this));
                        panel.add((Component)o, o.getTitle());
                        if (add) continue;
                        this.tabbed.add((Component)panel, title);
                        add = true;
                    }
                }
            }
            catch (ClassNotFoundException clazz2) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                clazz2 = Class.forName(pkg + ".ServicePropertiesPanel");
                if (!ServicePanel.isAllowedServiceAvaliable(clazz2)) continue;
                PatternModuleServicePanel servicePanel = new PatternModuleServicePanel(m);
                this.serviceModuleTabPanelItems.add(servicePanel);
                panel.add((Component)servicePanel, "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438");
                if (add) continue;
                this.tabbed.add((Component)panel, title);
                add = true;
                continue;
            }
            catch (ClassNotFoundException clazz3) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setData(Document doc) {
    }

    @Override
    public void setPatternData(Element pattern) {
        for (PatternModuleTabPanelItem patternModuleTabPanelItem : this.moduleTabPanelItems) {
            patternModuleTabPanelItem.setData(pattern);
        }
        for (PatternModuleServicePanel patternModuleServicePanel : this.serviceModuleTabPanelItems) {
            patternModuleServicePanel.setData(pattern);
        }
        this.modulesList.clear();
        for (Element element : XMLUtils.selectElements(pattern, "data/modules/*")) {
            this.modulesList.add(Utils.parseInt(element.getAttribute("mid"), 0));
        }
        this.rebuildList();
    }

    @Override
    public void resetData() {
        this.modulesList.clear();
        this.rebuildList();
        for (PatternModuleTabPanelItem patternModuleTabPanelItem : this.moduleTabPanelItems) {
            patternModuleTabPanelItem.reset();
        }
        for (PatternModuleServicePanel patternModuleServicePanel : this.serviceModuleTabPanelItems) {
            patternModuleServicePanel.reset();
        }
    }

    @Override
    public boolean setRequestData(Request request) {
        final Document doc = XMLUtils.newDocument();
        Element data = doc.createElement("data");
        Element modules = doc.createElement("modules");
        doc.appendChild(data);
        data.appendChild(modules);
        HashSet<Integer> modulesList = new HashSet<Integer>();
        for (IdTitle module : this.allModulesMap) {
            if (!this.modulesList.contains(module.getId())) continue;
            modulesList.add(module.getId());
        }
        Iterator<Serializable> iterator = modulesList.iterator();
        while (iterator.hasNext()) {
            int moduleId = (Integer)((Object)iterator.next());
            boolean fl = true;
            for (PatternModuleTabPanelItem patternModuleTabPanelItem : this.moduleTabPanelItems) {
                if (patternModuleTabPanelItem.getModuleId() != moduleId) continue;
                patternModuleTabPanelItem.serialise(modules);
                fl = false;
            }
            if (!fl) continue;
            XMLUtils.createElement(modules, "module").setAttribute("mid", String.valueOf(moduleId));
        }
        request.setAttribute("modules", new Writable(Writer.class){

            @Override
            public void write(Object w) throws IOException {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer serializer = tf.newTransformer();
                    serializer.setOutputProperty("encoding", "UTF-8");
                    serializer.setOutputProperty("indent", "yes");
                    serializer.transform(new DOMSource(doc), new StreamResult((Writer)w));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        for (PatternModuleServicePanel i : this.serviceModuleTabPanelItems) {
            if (!modulesList.contains(i.getMid())) continue;
            i.serialise(modules);
        }
        return true;
    }

    private void showConfigPanel() {
        this.tabbedLayout.show(this.tabbed, NOT_PANEL);
        IdTitle item = this.moduleList.getSelectedValue();
        if (item != null) {
            this.tabbedLayout.show(this.tabbed, item.getTitle());
        }
    }

    public static abstract class PatternModuleTabPanelItem
    extends JPanel {
        private int moduleId;
        protected Map<String, Element> cache;
        protected PatternModuleTabPanel patternModuleTabPanel;

        public PatternModuleTabPanelItem(LayoutManager layout, int moduleId) {
            super(layout);
            this.moduleId = moduleId;
        }

        protected final PatternModuleTabPanelItem init(Map<String, Element> cache, PatternModuleTabPanel patternModuleTabPanel) {
            this.cache = cache;
            this.patternModuleTabPanel = patternModuleTabPanel;
            this.init();
            return this;
        }

        protected abstract void init();

        protected Document getDocument(Request request) {
            return this.patternModuleTabPanel.getDocument(request);
        }

        protected void initBGPanel(BGPanel panel, String module, int moduleId) {
            panel.init(module, moduleId);
        }

        protected boolean checkStatus(Document doc) {
            return ClientUtils.checkStatus(doc);
        }

        public int getModuleId() {
            return this.moduleId;
        }

        protected abstract boolean isItemEnabled();

        protected abstract void setData(Element var1);

        protected abstract void reset();

        protected abstract void serialise(Element var1);

        public abstract String getTitle();
    }

    public static interface PatternModuleTabPanelItemFactory {
        public Collection<PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int var1, String var2);
    }

    public static interface PatternModuleTabPanelItemParams {
        public void serializeParams(Element var1);

        public void setParams(Element var1);

        public void initParams(int var1);
    }
}

