/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.sql.Connection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.ConnectionHolder;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.common.worker.WorkerThreadFactory;

final class EventListenerThreadContext
extends EventListenerContext {
    protected EventListenerThreadContext(ServerContext parent, String applicationName) {
        super(parent, applicationName);
    }

    protected EventListenerThreadContext(Setup setup, Connection con, String applicationName) {
        super(setup, ConnectionSet.newInstance((DefaultServerSetup)setup, con, false), applicationName);
    }

    protected EventListenerThreadContext(Setup setup, String applicationName) {
        super(setup, ConnectionSet.newInstance((DefaultServerSetup)setup, false), applicationName);
    }

    @Override
    public ConnectionSet getConnectionSet() {
        assert (this.connectionSet != null);
        if (this.connectionSet == null) {
            Object ctx = ThreadContext.get();
            if (ctx instanceof ConnectionHolder && ctx != this) {
                Connection con = ((ConnectionHolder)ctx).getConnection();
                this.connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, con, true);
                return this.connectionSet;
            }
            this.connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, true);
            return this.connectionSet;
        }
        return this.connectionSet;
    }

    public static ExecutorService newExecutorService(final EventProcessor ep, int count, int queue) {
        final ThreadContextFactory<ThreadContext> threadContextFactory = new ThreadContextFactory<ThreadContext>(){

            @Override
            public ThreadContext newThreadContext() {
                return new EventListenerContext(ep.setup, ep.applicationName);
            }
        };
        RejectedExecutionHandler callerRuns = new RejectedExecutionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                if (!e.isShutdown()) {
                    if (r instanceof WorkerTask) {
                        WorkerTask w = (WorkerTask)r;
                        Object context = threadContextFactory.newThreadContext();
                        ((ThreadContext)context).init();
                        try {
                            w.setContext(context);
                            w.run();
                            w.setContext(null);
                        }
                        finally {
                            ((ThreadContext)context).destroy();
                        }
                    } else {
                        r.run();
                    }
                }
            }
        };
        return WorkerTask.newFixedThreadPool("event-proc", "mq", threadContextFactory, count, Math.max(queue, 8), callerRuns);
    }

    public static WorkerThreadFactory<ThreadContext> newThreadFactory(final EventProcessor ep, String name) {
        ThreadContextFactory<ThreadContext> threadContextFactory = new ThreadContextFactory<ThreadContext>(){

            @Override
            public ThreadContext newThreadContext() {
                return new EventListenerContext(ep.setup, ep.applicationName);
            }
        };
        return new WorkerThreadFactory<ThreadContext>(name, "mq", threadContextFactory);
    }

    public static ExecutorService newExecutorService(EventProcessor ep, String name, int count, int queue) {
        WorkerThreadFactory<ThreadContext> threadFactory = EventListenerThreadContext.newThreadFactory(ep, name);
        return new ThreadPoolExecutor(count, count, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(Math.max(queue, 8)), threadFactory, new WorkerTask.BlockingExecutionHandler());
    }
}

