/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.server.bean.Register;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RegisterItemManager {
    private Connection con;

    public RegisterItemManager(Connection con) {
        this.con = con;
    }

    public void createTable(String tableName) throws SQLException {
        String query = "CREATE TABLE " + tableName + " (id int AUTO_INCREMENT PRIMARY KEY,unique_id varchar(60) NOT NULL,rid int default 0,cid int default 0,dt date,summa decimal(10,2) default 0,pid int default 0,ptid int default 0,comment varchar(200) default '',KEY rid(rid),KEY unique_id(unique_id) )";
        Setup.getSetup().checkAndCreatePeriodicTableName(this.con, tableName, query);
    }

    public void updateRegisterItem(Register register, RegisterItem item) {
        try {
            String query = null;
            PreparedStatement ps = null;
            String tableName = ServerUtils.getMonthTableName((String)"payment_register_item", (Date)register.getDate());
            this.createTable(tableName);
            this.kostylNumber1(tableName);
            this.kostylNumber2(tableName);
            if (item.getId() <= 0) {
                query = "INSERT INTO " + tableName + " ( rid, cid, summa, pid, ptid, comment, dt, unique_id ) VALUES ( ?, ?, ?, ?, ?, ?, ? , ? )";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + tableName + " SET rid=?, cid=?, summa=?, pid=?, ptid=?, comment=?, dt=?, unique_id=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(9, item.getId());
            }
            ps.setInt(1, item.getRegisterId());
            ps.setInt(2, item.getContractId());
            ps.setBigDecimal(3, item.getSumma());
            ps.setInt(4, item.getBalanceItemId());
            ps.setInt(5, item.getBalanceItemTypeId());
            ps.setString(6, item.getBalanceItemComment());
            ps.setDate(7, TimeUtils.convertDateToSqlDate(item.getDate()));
            ps.setString(8, item.getUniqueId());
            ps.executeUpdate();
            if (item.getId() <= 0) {
                item.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteRegisterItems(Register register) {
        try {
            String tableName = ServerUtils.getMonthTableName((String)"payment_register_item", (Date)register.getDate());
            if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                return;
            }
            String query = "DELETE FROM " + tableName + " WHERE rid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, register.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<RegisterItem> getRegisterItems(Register register) {
        ArrayList<RegisterItem> result = new ArrayList<RegisterItem>();
        try {
            String tableName = ServerUtils.getMonthTableName((String)"payment_register_item", (Date)register.getDate());
            if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                return result;
            }
            this.kostylNumber2(tableName);
            String query = "SELECT * FROM " + tableName + " WHERE rid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, register.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RegisterItem item = new RegisterItem();
                this.loadItemFromRS(item, rs, register.getRegisterType());
                result.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String checkItemsWithUniqueId(Register register, String id) {
        try {
            if (Utils.isBlankString(id)) {
                return null;
            }
            String tableName = ServerUtils.getMonthTableName((String)"payment_register_item", (Date)register.getDate());
            if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                String query = "SELECT item.id, register.date, register.title, contract.title FROM " + tableName + " AS item LEFT JOIN payment_register  AS register ON item.rid=register.id LEFT JOIN contract ON item.cid=contract.id WHERE unique_id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    String error = "\u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u044b\u043c id \u0435\u0441\u0442\u044c \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 " + rs.getString(3) + " \u043e\u0442 " + TimeUtils.formatDate(rs.getDate(2));
                    String contract = rs.getString(4);
                    if (Utils.notBlankString(contract)) {
                        error = error + " \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract;
                    }
                    return error;
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void loadItemFromRS(RegisterItem item, ResultSet rs, int type) throws SQLException {
        item.setId(rs.getInt("id"));
        item.setBalanceItemId(rs.getInt("pid"));
        item.setBalanceItemTypeId(rs.getInt("ptid"));
        item.setRegisterId(rs.getInt("rid"));
        item.setSumma(rs.getBigDecimal("summa"));
        item.setContractId(rs.getInt("cid"));
        item.setBalanceItemComment(rs.getString("comment"));
        item.setDate(rs.getDate("dt"));
        try {
            item.setUniqueId(rs.getString("unique_id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    private void kostylNumber1(String tableName) throws SQLException {
        if (!ServerUtils.columnExist((Connection)this.con, (String)tableName, (String)"unique_id")) {
            Statement st = this.con.createStatement();
            String query = "ALTER TABLE " + tableName + " ADD unique_id varchar(20) NOT NULL";
            st.executeUpdate(query);
            query = "ALTER TABLE " + tableName + " ADD KEY unique_id(unique_id)";
            st.executeUpdate(query);
        }
    }

    @Deprecated
    private void kostylNumber2(String tableName) throws SQLException {
        if (!ServerUtils.columnExist((Connection)this.con, (String)tableName, (String)"ptid")) {
            Statement st = this.con.createStatement();
            Object query = "ALTER TABLE " + tableName + " ADD ptid int NOT NULL";
            st.executeUpdate((String)query);
            query = "SELECT DISTINCT rid FROM " + tableName;
            ResultSet rs = st.executeQuery((String)query);
            query = "SELECT pt FROM payment_register WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            while (rs.next()) {
                int rid = rs.getInt(1);
                ps.setInt(1, rid);
                ResultSet ptrs = ps.executeQuery();
                if (ptrs.next()) {
                    int pt = ptrs.getInt(1);
                    if (pt <= 0) continue;
                    query = "UPDATE " + tableName + " SET ptid=? WHERE rid=?";
                    PreparedStatement itemUpdatePs = this.con.prepareStatement((String)query);
                    itemUpdatePs.setInt(1, pt);
                    itemUpdatePs.setInt(2, rid);
                    itemUpdatePs.executeUpdate();
                    itemUpdatePs.close();
                }
                ptrs.close();
            }
            rs.close();
            ps.close();
            st.close();
        }
    }
}

