/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.editor.MultiSelectEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public abstract class MultiSelect2TariffTreeNode
extends DefaultTariffTreeNode {
    private MultiSelectEditor multiSelectEditor;
    private JLabel view = new JLabel();
    private Directory dir;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(this.getIcon());
    }

    @Override
    public Component getView() {
        Map<String, String> data = this.getDataInHash();
        StringBuffer str = new StringBuffer();
        Utils.toIntegerList(data.get(this.getStoreKey())).forEach(id -> str.append(str.length() > 0 ? ";" : "").append(" ").append(this.getValue((int)id)));
        this.view.setText(this.getViewLabel(data) + str.toString());
        return this.view;
    }

    protected Directory getDirectory() {
        if (this.dir == null) {
            this.dir = this.getDirManager().getDirectory(this.getDirName());
        }
        return this.dir;
    }

    protected String getValue(int serviceId) {
        if (this.getDirectory() != null) {
            return this.getDirectory().getValue(serviceId);
        }
        return "???[#" + serviceId + "]";
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.multiSelectEditor == null) {
            this.multiSelectEditor = new MultiSelectEditor<IdTitle>(this.getDirectory().getItems());
        }
        return this.multiSelectEditor;
    }

    protected String getViewLabel(Map<String, String> data) {
        return this.getViewLabel();
    }

    @Override
    protected void loadData() {
        ((MultiSelectEditor)this.getEditorPanel()).setSelect(this.getDataInHash().getOrDefault(this.getStoreKey(), ""));
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(this.getStoreKey(), this.multiSelectEditor.getSelect());
        this.setDataInHash(data);
    }

    @Override
    public void serializeToXML(Element element) {
        super.serializeToXML(element);
        this.serializeChildsToXML(element);
    }

    @Override
    public void loadFromXML(Element element) {
        this.loadChildsFromXML(element);
    }

    protected abstract String getDirName();

    protected abstract String getViewLabel();

    protected abstract String getStoreKey();

    protected abstract Icon getIcon();
}

