/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public class ProductSpecActivationModePanel
extends BGUPanel {
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private ProductSpecActivationModeTableModel model = new ProductSpecActivationModeTableModel();

    public ProductSpecActivationModePanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        BGSwingUtilites.handleEdit(table, this);
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, table, "enabled", "oldValue"));
        BGSwingUtilites.buildToolBar(this.toolBar, this);
        this.toolBar.compact();
    }

    public void setData(List<ProductSpecActivationMode> modeList) {
        this.model.setData(modeList);
    }

    public List<ProductSpecActivationMode> getData() {
        return this.model.getRows();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationMode mode = new ProductSpecActivationMode();
                mode.setDateFrom(new Date());
                new EditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c", mode, true).getDialog().setVisible(true);
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationMode mode = (ProductSpecActivationMode)ProductSpecActivationModePanel.this.model.getSelectedRow();
                if (mode == null) {
                    return;
                }
                new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c", mode, false).getDialog().setVisible(true);
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationModePanel.this.model.deleteSelectedRows();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
    }

    private class ProductSpecActivationModeTableModel
    extends BGTableModel<ProductSpecActivationMode> {
        public ProductSpecActivationModeTableModel() {
            super(ProductSpecActivationModeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 150, -1, "title", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 300, 300, 300, "deak", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 150, 150, 150, "reak", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(ProductSpecActivationMode productSpecActivationMode, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                return TimeUtils.formatPeriod(productSpecActivationMode.getDateFrom(), productSpecActivationMode.getDateTo());
            }
            if ("deak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getDeactivationMode()) {
                    case 10: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430";
                    }
                    case 0: {
                        return "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e";
                    }
                    case 2: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430";
                    }
                    case 3: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f";
                    }
                    case 4: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438";
                    }
                    case 5: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430";
                    }
                }
                return null;
            }
            if ("reak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getReactivationMode()) {
                    case 0: {
                        return "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430";
                    }
                    case 1: {
                        return "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430";
                    }
                }
                return null;
            }
            return super.getValue(productSpecActivationMode, column);
        }
    }

    private class EditorDialog
    extends BGEditorDialog<ProductSpecActivationMode> {
        private boolean newMode;
        private BGTextField title;
        private BGControlPanelPeriodNoB period;
        private IntTextField periodColTF;
        private BGUComboBox<IdTitle> periodModeField;
        private BGUComboBox<IdTitle> periodModeBegin;
        private BGUComboBox<IdTitle> periodModeEnd;
        private BGUComboBox<IdTitle> deactivationModeCB;
        private BGUComboBox<IdTitle> reactivationModeCB;
        private IdTitle[] deactivationModes;
        private IdTitle[] reactivationModes;
        private IdTitle[] periodModeFields;
        private IdTitle[] periodModeBegins;
        private IdTitle[] periodModeEnds;

        public EditorDialog(String title, ProductSpecActivationMode data, boolean newMode) {
            super(title, data);
            this.newMode = false;
            this.title = new BGTextField();
            this.period = new BGControlPanelPeriodNoB();
            this.periodColTF = new IntTextField(5);
            this.periodModeField = new BGUComboBox();
            this.periodModeBegin = new BGUComboBox();
            this.periodModeEnd = new BGUComboBox();
            this.deactivationModeCB = new BGUComboBox();
            this.reactivationModeCB = new BGUComboBox();
            this.deactivationModes = new IdTitle[]{new IdTitle(10, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new IdTitle(0, "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e"), new IdTitle(2, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430"), new IdTitle(3, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f"), new IdTitle(4, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new IdTitle(5, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430")};
            this.reactivationModes = new IdTitle[]{new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430")};
            this.periodModeFields = new IdTitle[]{new IdTitle(1, "\u043c\u0438\u043d\u0443\u0442"), new IdTitle(2, "\u0447\u0430\u0441\u043e\u0432"), new IdTitle(3, "\u0434\u043d\u0435\u0439"), new IdTitle(4, "\u043d\u0435\u0434\u0435\u043b\u044c"), new IdTitle(5, "\u043c\u0435\u0441\u044f\u0446\u0435\u0432")};
            this.periodModeBegins = new IdTitle[]{new IdTitle(1, "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430"), new IdTitle(2, "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e(\u0435\u0439)"), new IdTitle(3, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e(\u0435\u0439)"), new IdTitle(4, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0447\u0430\u0441\u0430")};
            this.periodModeEnds = new IdTitle[]{new IdTitle(1, "\u0440\u043e\u0432\u043d\u043e"), new IdTitle(2, "\u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u043d\u043e")};
            this.newMode = newMode;
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add(this.deactivationModeCB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add(this.reactivationModeCB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 10, 0), 0, 0));
            this.deactivationModeCB.setData(Arrays.asList(this.deactivationModes));
            this.reactivationModeCB.setData(Arrays.asList(this.reactivationModes));
            this.periodModeField.setData(Arrays.asList(this.periodModeFields));
            this.periodModeBegin.setData(Arrays.asList(this.periodModeBegins));
            this.periodModeEnd.setData(Arrays.asList(this.periodModeEnds));
            int[] modeValue = ProductSpecActivationMode.mode((int)((ProductSpecActivationMode)this.data).getPeriodMode());
            this.periodModeField.setSelectedItem(modeValue[0]);
            this.periodModeBegin.setSelectedItem(modeValue[1]);
            this.periodModeEnd.setSelectedItem(modeValue[2]);
            this.title.setText(((ProductSpecActivationMode)this.data).getTitle());
            this.period.setLocalDateFrom(TimeUtils.convertDateToLocalDate(((ProductSpecActivationMode)this.data).getDateFrom()));
            this.period.setLocalDateTo(TimeUtils.convertDateToLocalDate(((ProductSpecActivationMode)this.data).getDateTo()));
            this.deactivationModeCB.setSelectedItem(((ProductSpecActivationMode)this.data).getDeactivationMode());
            this.reactivationModeCB.setSelectedItem(((ProductSpecActivationMode)this.data).getReactivationMode());
            this.periodColTF.setText(String.valueOf(((ProductSpecActivationMode)this.data).getPeriodAmount()));
        }

        private JPanel getPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.periodColTF, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.periodModeField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add(this.periodModeBegin, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add(this.periodModeEnd, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            int modeField = ((IdTitle)this.periodModeField.getSelectedItem()).getId();
            int modeBegin = ((IdTitle)this.periodModeBegin.getSelectedItem()).getId();
            int modeEnd = ((IdTitle)this.periodModeEnd.getSelectedItem()).getId();
            ((ProductSpecActivationMode)this.data).setTitle(this.title.getText());
            ((ProductSpecActivationMode)this.data).setDateFrom(TimeUtils.convertLocalDateToDate(this.period.getLocalDateFrom()));
            ((ProductSpecActivationMode)this.data).setDateTo(TimeUtils.convertLocalDateToDate(this.period.getLocalDateTo()));
            ((ProductSpecActivationMode)this.data).setDeactivationMode(((IdTitle)this.deactivationModeCB.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setReactivationMode(((IdTitle)this.reactivationModeCB.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setPeriodMode(modeField + modeBegin * 10 + modeEnd * 100);
            ((ProductSpecActivationMode)this.data).setPeriodAmount(Utils.parseInt(this.periodColTF.getText()));
            if (this.newMode) {
                ProductSpecActivationModePanel.this.model.getRows().add((ProductSpecActivationMode)this.data);
            }
            ProductSpecActivationModePanel.this.model.fireTableDataChanged();
            return true;
        }
    }
}

