/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecFilter;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecForm;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class ProductSpecPanel
extends BGUPanel {
    public static final int MODE_EDIT = 0;
    public static final int MODE_SELECT = 1;
    private int mode = 0;
    private BGEditor editor;
    private BGUTreeTable table;
    private ProductSpecFilter filter;
    private ProductService productService;
    private ProductSpecTreeTableModel model;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            String title = ProductSpecPanel.this.filter.mainFilter.title.getText();
            Date dateFrom = TimeUtils.convertCalendarToDate(ProductSpecPanel.this.filter.mainFilter.period.getDateCalendar1());
            Date dateTo = TimeUtils.convertCalendarToDate(ProductSpecPanel.this.filter.mainFilter.period.getDateCalendar2());
            ProductSpecPanel.this.getProductSpecTreeTableModel().setData(ProductSpecPanel.this.getProductService().productSpecTree(Integer.valueOf(((ClientContext)ProductSpecPanel.this.getContext()).getModuleId()), dateFrom, dateTo, title, ProductSpecPanel.this.filter.getFilters()));
            ProductSpecPanel.this.table.expandAfterUpdate();
        }
    };

    public ProductSpecPanel() {
        super(new BorderLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        this.table = new BGUTreeTable(this.getProductSpecTreeTableModel());
        JPanel rightPanel = new JPanel(new BorderLayout());
        BGFilterPane splitPane = new BGFilterPane(this.mode != 0);
        if (this.mode == 0) {
            this.editor = new BGEditor("table");
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.setName("table");
            tablePanel.add((Component)new JScrollPane(this.table), "Center");
            rightPanel.add((Component)this.editor, "Center");
            this.filter = new ProductSpecFilter(this, (ClientContext)this.getContext());
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(tablePanel);
            this.editor.addForm(splitPane, "table");
            this.editor.addForm(new ProductSpecForm(this, (ClientContext)this.getContext()));
            this.add((Component)this.editor, "Center");
            BGSwingUtilites.handleEdit(this.table, this);
        } else {
            rightPanel.add((Component)new JScrollPane(this.table), "Center");
            this.filter = new ProductSpecFilter(this, (ClientContext)this.getContext());
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(rightPanel);
            this.add((Component)splitPane, "Center");
        }
    }

    ProductSpecTreeTableModel getProductSpecTreeTableModel() {
        if (this.model == null) {
            this.model = new ProductSpecTreeTableModel(ProductSpecTreeTableModel.class.getName());
        }
        return this.model;
    }

    ProductService getProductService() {
        if (this.productService == null) {
            this.productService = ((ClientContext)this.getContext()).getPort(ProductService.class, 0);
        }
        return this.productService;
    }

    protected int getEntitySpecId() throws BGException {
        return 0;
    }

    class ProductSpecTreeTableModel
    extends BGTreeTableModel<ProductSpec> {
        private final Icon iconRoot;
        private final Icon iconNode;
        private final Icon iconLeaf;

        public ProductSpecTreeTableModel(String name) {
            super(name);
            this.iconRoot = ClientUtils.getIcon("fugue/folder");
            this.iconNode = ClientUtils.getIcon("fugue/folder");
            this.iconLeaf = ClientUtils.getIcon("fugue/present");
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", ProductSpec.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", 100, 150, 200, "identifier", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        @Override
        public Object getValue(ProductSpec val, int column) throws BGException {
            Object value = null;
            switch (column) {
                case 0: {
                    if (val == this.root) {
                        value = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b";
                        break;
                    }
                    value = val.getTitle();
                    break;
                }
                default: {
                    value = super.getValue(val, column);
                }
            }
            return value;
        }

        @Override
        public Icon getIcon(ProductSpec value) {
            if (value == this.root) {
                return this.iconRoot;
            }
            if (this.isLeaf(value)) {
                return this.iconLeaf;
            }
            return this.iconNode;
        }
    }
}

