/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.reports;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import ru.bitel.common.reports.Series;
import ru.bitel.common.reports.SeriesCollection;
import ru.bitel.common.reports.SeriesDataItem;
import ru.bitel.common.reports.TimeSeries;
import ru.bitel.common.reports.TimeSeriesDataItem;

@XmlSeeAlso(value={TimeSeries.class, TimeSeriesDataItem.class})
public class TimeSeriesCollection<K extends Temporal, V>
extends SeriesCollection<K, V> {
    private ChronoUnit period;
    private transient K xMin;
    private transient K xMax;
    private transient boolean normalized = false;
    private List<K> xAxisValues;

    protected TimeSeriesCollection() {
    }

    private static <K extends Temporal & Comparable<Temporal>> Comparator comparator(ChronoUnit period) {
        return new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    public TimeSeriesCollection(ChronoUnit period, BiFunction<V, V, V> plus) {
        super(TimeSeriesCollection.comparator(period), plus);
        this.period = period;
    }

    public ChronoUnit getPeriod() {
        return this.period;
    }

    public void setPeriod(ChronoUnit period) {
        this.period = period;
    }

    @Override
    public void setSeries(List<Series<K, V>> series) {
        this.series = series;
        this.reset();
    }

    @Override
    public void addSeries(Series<K, V> series) {
        this.series.add(series);
        this.reset();
    }

    public Temporal getXMin() {
        return this.xMin;
    }

    public TimeSeriesCollection<K, V> setXMin(K xMin) {
        this.xMin = xMin;
        this.reset();
        return this;
    }

    public Temporal getXMax() {
        return this.xMax;
    }

    public TimeSeriesCollection<K, V> setXMax(K xMax) {
        this.xMax = xMax;
        this.reset();
        return this;
    }

    private void reset() {
        this.xAxisValues = null;
    }

    @XmlTransient
    public List<K> getXAxisValues() {
        if (this.xAxisValues != null) {
            return this.xAxisValues;
        }
        Object min = this.xMin;
        Object max = this.xMax;
        for (Series series : this.series) {
            for (SeriesDataItem item : series.getItems()) {
                Temporal key = (Temporal)item.key;
                if (min == null || this.comparator.compare(key, min) < 0) {
                    min = key;
                }
                if (max != null && this.comparator.compare(key, max) <= 0) continue;
                max = key;
            }
        }
        ArrayList<K> list = new ArrayList<K>();
        long count = this.period.between((Temporal)min, (Temporal)max);
        Object current = min;
        list.add(current);
        int i = 0;
        while ((long)i < count) {
            current = current.plus(1L, this.period);
            list.add(current);
            ++i;
        }
        this.xAxisValues = list;
        return list;
    }

    public TimeSeriesCollection<K, V> normalize() {
        if (this.normalized) {
            return this;
        }
        List<K> labels = this.getXAxisValues();
        if (labels.size() == 0) {
            this.normalized = true;
            return this;
        }
        for (Series series : this.series) {
            List itemList = series.getItems();
            if (itemList.size() == labels.size()) continue;
            ArrayList newItemList = new ArrayList(labels.size());
            if (itemList.size() == 0) {
                for (Temporal k : labels) {
                    newItemList.add(new SeriesDataItem<Temporal, Object>(k, null));
                }
                series.setItems(newItemList);
                continue;
            }
            int i = 1;
            SeriesDataItem current = itemList.get(0);
            for (Temporal k : labels) {
                if (current != null && k.equals(current.key)) {
                    current.key = k;
                    newItemList.add(current);
                    if (i >= itemList.size()) {
                        current = null;
                        continue;
                    }
                    current = itemList.get(i++);
                    continue;
                }
                newItemList.add(new SeriesDataItem<Temporal, Object>(k, null));
            }
            series.setItems(newItemList);
        }
        this.normalized = true;
        return this;
    }

    @Override
    public Series<K, V> newSeries(String title, String description) {
        return new TimeSeries(this, title, description);
    }
}

