/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.access.om;

import java.sql.Connection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.apps.voice.access.om.OrderManagerSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.AsyncEventWorker;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceAccountDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountModifyEvent;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountStateModifyEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;

public class OrderManagerDeviceWorker
extends AsyncEventWorker<Event> {
    private final Logger logger = LogManager.getLogger();
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile Future<?> future;
    private final long fetchDelay = 200L;
    private final long fetchTimeout = 200L;
    private final int deviceId;
    private OrderManagerSet orderManagers;
    private final VoiceApplication application;
    private Connection con = null;
    private VoiceAccountDao voiceAccountDao;
    private EventProcessor ep;

    public OrderManagerDeviceWorker(VoiceApplication application, ScheduledExecutorService scheduledExecutorService, int deviceId) throws BGException {
        super(EventProcessor.getInstance(), OmVoiceAccountModifyEvent.class.getPackage().getName() + ".*", application.getModuleId(), -1, "deviceId=" + deviceId, false, new Class[]{OmVoiceAccountModifyEvent.class, OmVoiceAccountStateModifyEvent.class});
        this.deviceId = deviceId;
        this.application = application;
        this.scheduledExecutorService = scheduledExecutorService;
        this.future = scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 3000L, 200L, TimeUnit.MILLISECONDS);
        this.logger.info("Starting deviceWorker for device " + deviceId);
    }

    protected synchronized void runImpl() throws Exception {
        int result = this.internalRunWorker(200L, false);
        if (result < 0) {
            this.logger.info("Execution error - waiting " + this.errorPause + "ms for next try.");
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, 200L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runWorker() throws BGException {
        boolean bl;
        ServerContext serverContext = null;
        VoiceDeviceRuntime deviceRuntime = this.application.getDeviceRuntimeMap().get(this.deviceId);
        if (deviceRuntime == null) {
            this.logger.error("device is empty for id " + this.deviceId);
        }
        try {
            this.orderManagers = deviceRuntime.getOmInstances();
            serverContext = new ServerContext(this.application.getSetup(), ConnectionSet.newInstance((DefaultServerSetup)this.application.getSetup(), (boolean)true), this.moduleId, 0);
            this.con = serverContext.getConnectionSet().getConnection();
            this.voiceAccountDao = new VoiceAccountDao(this.con, this.moduleId);
            this.orderManagers.connect();
            this.ep = EventProcessor.getInstance();
            bl = this.doTasks();
        }
        catch (Throwable throwable) {
            this.orderManagers.disconnect(serverContext);
            this.voiceAccountDao.close();
            this.voiceAccountDao = null;
            if (serverContext != null) {
                serverContext.recycle();
                serverContext = null;
            }
            this.con = null;
            this.orderManagers = null;
            this.ep = null;
            throw throwable;
        }
        this.orderManagers.disconnect(serverContext);
        this.voiceAccountDao.close();
        this.voiceAccountDao = null;
        if (serverContext != null) {
            serverContext.recycle();
            serverContext = null;
        }
        this.con = null;
        this.orderManagers = null;
        this.ep = null;
        return bl;
    }

    public Object doTask(Object task) throws BGException {
        try {
            this.logger.info("Do task deviceId: " + this.deviceId + "; " + task);
            AccountOrderEvent result = null;
            if (task instanceof OmVoiceAccountModifyEvent) {
                result = ((OmVoiceAccountModifyEvent)((Object)task)).toAccountOrderEvent(this.application, this.con);
            } else if (task instanceof OmVoiceAccountStateModifyEvent) {
                result = ((OmVoiceAccountStateModifyEvent)((Object)task)).toAccountOrderEvent(this.application);
            }
            if (result == null) {
                this.logger.debug("skiping event ");
                return true;
            }
            return new Object[]{this.doCommand(result), result};
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            throw new BGException((Throwable)e);
        }
    }

    private Object doCommand(AccountOrderEvent event) throws Exception {
        boolean result = true;
        switch (event.getEventType()) {
            case 2: {
                result = this.orderManagers.accountModify(this, event);
                break;
            }
            case 1: {
                result = this.orderManagers.accountCreate(this, event);
                break;
            }
            case 3: {
                result = this.orderManagers.accountRemove(this, event);
                break;
            }
            case 4: {
                result = this.orderManagers.accountStateModify(this, event);
            }
        }
        return result;
    }

    protected void taskDone(Object task, Object result) throws BGException {
        boolean stateModified;
        boolean ok;
        boolean bl = ok = !Boolean.FALSE.equals(result);
        if (!ok) {
            this.logger.warn("Task return false");
            return;
        }
        if (!(task instanceof Object[])) {
            return;
        }
        Object[] array = (Object[])task;
        AccountOrderEvent event = (AccountOrderEvent)array[1];
        if (event.getEventType() != 2 && event.getEventType() != 1 && event.getEventType() != 3 && event.getEventType() != 4) {
            return;
        }
        boolean bl2 = stateModified = event.getOldState() != event.getNewState();
        if (stateModified && event.isFireDeviceStateCnanged()) {
            this.fireAccountDeviceStateModified(event, event.getNewState());
        }
    }

    private void fireAccountDeviceStateModified(AccountOrderEvent event, short newState) throws BGException {
        this.logger.info("Changing VoiceAccount:" + event.getAccountId() + " state and/or options");
        try {
            this.voiceAccountDao.updateDeviceState(event.getAccountId(), newState, 0);
            this.ep.publish((Event)new VoiceAccountDeviceStateModifiedEvent(this.application.getModuleId(), this.deviceId, event.getAccountId(), newState));
        }
        catch (Exception t) {
            this.logger.error("Error in fireAccountDeviceStateModified(accountId = " + event.getAccountId() + ")" + t.getMessage(), (Throwable)t);
        }
    }
}

