/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;

public class VoiceDestinationDao
extends AbstractIdDao<VoiceDestination> {
    public static final String VOICE_DESTINATION_TABLE = "voice_destination";

    public VoiceDestinationDao(Connection con, int mid) {
        super(con, mid, VOICE_DESTINATION_TABLE);
    }

    protected VoiceDestination getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceDestination result = new VoiceDestination(rs.getInt("id"), rs.getString("title"));
        result.setOperatorId(rs.getInt("operatorId"));
        return result;
    }

    protected void updateImpl(VoiceDestination b) throws BGException, SQLException {
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, operatorId=? WHERE id=?" : "INSERT INTO " + this.tableName + "(title,operatorId) VALUES (?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            if (b.getOperatorId() > 0) {
                ps.setInt(index++, b.getOperatorId());
            } else {
                ps.setNull(index++, 4);
            }
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public Map<String, VoiceDestination> titleMap(int operatorId) throws BGException {
        return this.list(operatorId, null, null).stream().collect(Collectors.toMap(IdTitle::getTitle, Function.identity()));
    }

    public Map<Integer, VoiceDestination> idMap(int operatorId) throws BGException {
        return this.list(operatorId, null, null).stream().collect(Collectors.toMap(Id::getId, Function.identity()));
    }

    public List<VoiceDestination> list(int operatorId, String title, Page page) throws BGException {
        ArrayList<VoiceDestination> result = new ArrayList<VoiceDestination>();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE ";
        Object whereClause = "1=1 ";
        whereClause = (String)whereClause + " AND operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL");
        if (Utils.notBlankString((String)title)) {
            whereClause = (String)whereClause + " AND title LIKE ?";
        }
        query = query + (String)whereClause;
        query = query + " ORDER BY title";
        if (page != null && page.getPageSize() > 0) {
            query = query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            if (Utils.notBlankString((String)title)) {
                ps.setString(index++, "%" + title + "%");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public int delete(List<Integer> idList) throws BGException {
        int result = 0;
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(idList) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            result = ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public VoiceDestination get(String title) throws BGException {
        VoiceDestination result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE title=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, title);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

