/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public class VoiceDeviceTypeDao
extends DeviceTypeDao<VoiceDeviceType> {
    public VoiceDeviceTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_device_type");
    }

    protected VoiceDeviceType getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceDeviceType result = new VoiceDeviceType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setConfig(rs.getString("config"));
        result.setComment(rs.getString("comment"));
        result.setNas(rs.getBoolean("nas"));
        result.setSource(rs.getBoolean("source"));
        result.setDeviceEntitySpecId(rs.getInt("entitySpecId"));
        result.setMediationHandlerClass(rs.getString("mediationClass"));
        result.setMediationRuntimeHandlerClass(rs.getString("mediationRuntimeClass"));
        result.setSaHandlerClass(rs.getString("omHandlerClass"));
        result.setProtocolHandlerClass(rs.getString("protocolHandlerClass"));
        result.setDeviceManagerClass(rs.getString("deviceManagerClass"));
        return result;
    }

    protected void updateImpl(VoiceDeviceType voiceDeviceType) throws BGException, SQLException {
        boolean insert = voiceDeviceType.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, mediationClass=?, mediationRuntimeClass=?, config=?, comment=?, nas=?, source=?, omHandlerClass=?, protocolHandlerClass=?, entitySpecId=?, deviceManagerClass=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, voiceDeviceType.getTitle());
            ps.setString(index++, voiceDeviceType.getMediationHandlerClass());
            ps.setString(index++, voiceDeviceType.getMediationRuntimeHandlerClass());
            ps.setString(index++, voiceDeviceType.getConfig());
            ps.setString(index++, voiceDeviceType.getComment());
            ps.setBoolean(index++, voiceDeviceType.isNas());
            ps.setBoolean(index++, voiceDeviceType.isSource());
            ps.setString(index++, voiceDeviceType.getOmHandlerClass());
            ps.setString(index++, voiceDeviceType.getProtocolHandlerClass());
            ps.setInt(index++, voiceDeviceType.getDeviceEntitySpecId());
            ps.setString(index++, voiceDeviceType.getDeviceManagerClass());
            if (!insert) {
                ps.setInt(index++, voiceDeviceType.getId());
            }
            ps.executeUpdate();
            if (insert) {
                voiceDeviceType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected VoiceDeviceType newDeviceType() {
        return new VoiceDeviceType();
    }
}

