/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionDetailOrder;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class VoiceSessionDetailOrderDao
extends AbstractDao<VoiceSessionDetailOrder> {
    public VoiceSessionDetailOrderDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_session_detail_order");
    }

    public List<VoiceSessionDetailOrder> list(int accountId, int contractId) throws BGException {
        return super.list("`account_id`=? AND `contract_id`=?", "12 * `year` + `month` DESC", new Object[]{accountId, contractId});
    }

    public List<VoiceSessionDetailOrder> list(VoiceSessionDetailOrder.Status status) throws BGException {
        return super.list("`status`=?", "create_date", new Object[]{status.name()});
    }

    protected VoiceSessionDetailOrder getFromRS(ResultSet rs) throws SQLException, BGException {
        return new VoiceSessionDetailOrder.VoiceSessionDetailOrderBuilder().setCreateDate((Date)rs.getTimestamp("create_date")).setStatus(VoiceSessionDetailOrder.Status.valueOf((String)rs.getString("status"))).setContractId(rs.getInt("contract_id")).setAccountId(rs.getInt("account_id")).setMonth(rs.getInt("month")).setYear(rs.getInt("year")).setFormatType(VoiceSessionDetailOrder.FormatType.valueOf((String)rs.getString("format_type"))).setEmail(rs.getString("email")).setEmailSend(VoiceSessionDetailOrder.EmailSend.valueOf((String)rs.getString("email_send"))).setFileSize(rs.getLong("file_size")).build();
    }

    protected void updateImpl(VoiceSessionDetailOrder voiceSessionDetailOrder) throws BGException, SQLException {
        Objects.requireNonNull(voiceSessionDetailOrder, "voiceSessionDetailOrder = null");
        String query = "INSERT INTO " + this.tableName + " SET `create_date`=?, `status`=?, `contract_id`=?, `account_id`=?, `month`=?, `year`=?, `format_type`=?, `email`=?, `email_send`=?, `file_size`=? ON DUPLICATE KEY UPDATE `status`=?, `format_type`=?, `email`=?, `email_send`=?, `file_size`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)voiceSessionDetailOrder.getCreateDate()));
            ps.setString(index++, voiceSessionDetailOrder.getStatus().name());
            ps.setInt(index++, voiceSessionDetailOrder.getContractId());
            ps.setInt(index++, voiceSessionDetailOrder.getAccountId());
            ps.setInt(index++, voiceSessionDetailOrder.getMonth());
            ps.setInt(index++, voiceSessionDetailOrder.getYear());
            ps.setString(index++, voiceSessionDetailOrder.getFormatType().name());
            ps.setString(index++, voiceSessionDetailOrder.getEmail());
            ps.setString(index++, voiceSessionDetailOrder.getEmailSend().name());
            ps.setLong(index++, voiceSessionDetailOrder.getFileSize());
            ps.setString(index++, voiceSessionDetailOrder.getStatus().name());
            ps.setString(index++, voiceSessionDetailOrder.getFormatType().name());
            ps.setString(index++, voiceSessionDetailOrder.getEmail());
            ps.setString(index++, voiceSessionDetailOrder.getEmailSend().name());
            ps.setLong(index++, voiceSessionDetailOrder.getFileSize());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int delete(VoiceSessionDetailOrder voiceSessionDetailOrder) throws BGException {
        Objects.requireNonNull(voiceSessionDetailOrder, "voiceSessionDetailOrder = null");
        return super.delete("`account_id`=? AND `month`=? AND `year`=?", new Object[]{voiceSessionDetailOrder.getAccountId(), voiceSessionDetailOrder.getMonth(), voiceSessionDetailOrder.getYear()});
    }
}

