/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.bean.VoiceTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.AddCallCostTariffTreeNode;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.ThreadContext;

public class VoiceSessionRuntime
implements AccountingSession {
    public static final short STATUS_ALIVE = 0;
    public static final short STATUS_FINESHED = 1;
    private static final Logger logger = LogManager.getLogger();
    private final VoiceSession session;
    private int contractId = 0;
    private final VoiceAbtractAccountRuntime<?> accountRuntime;
    private String tarifficationNumber;
    private Map<Integer, SessionAccountAmount> accountAmountMap = new HashMap<Integer, SessionAccountAmount>();
    Map<Integer, SessionAccountAmount> accountDeltaMap = new HashMap<Integer, SessionAccountAmount>();
    private long calculateAmountDelta = 0L;
    private TrafficRangeEntry rangedTraffic;
    private final boolean isOperSession;
    private VoiceSessionRuntime parentSession;
    private Set<Integer> optionsSet = new HashSet<Integer>();

    public VoiceSessionRuntime(VoiceSession session, VoiceAbtractAccountRuntime<?> accountRuntime) {
        this.session = session;
        this.contractId = session.getContractId();
        this.accountRuntime = accountRuntime;
        this.tarifficationNumber = this.session.getE164CalledStationId();
        this.isOperSession = accountRuntime instanceof VoiceOperAccountRuntime;
    }

    public String getUserName() {
        return null;
    }

    public VoiceSession getSession() {
        return this.session;
    }

    public TrafficRangeEntry getRangedTraffic() {
        return this.rangedTraffic;
    }

    public void setRangedTraffic(TrafficRangeEntry rangedTraffic) {
        this.rangedTraffic = rangedTraffic;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int calculate(VoiceTariffContext tariffContext, boolean round) throws BGException {
        return this.calculate(tariffContext, null, round);
    }

    public int calculate(VoiceTariffContext tariffContext, Long amount, boolean round) throws BGException {
        VoiceOperAccountRuntime operAccountRuntime;
        int serviceId;
        VoiceTariffWorkerContext workerContext = (VoiceTariffWorkerContext)VoiceTariffWorkerContext.get();
        int moduleId = workerContext.getModuleId();
        VoiceTariffRequest tariffRequest = new VoiceTariffRequest(moduleId, this.session.getContractId(), this.session.getId(), null, 0, 0L, 0L, this);
        tariffRequest.setTime(TimeUtils.convertDateToCalendar((Date)this.session.getSessionStart()));
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(serverContext.getConnectionSet(), Integer.valueOf(this.contractId));
        ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(tariffRequest.getTime().getTimeInMillis());
        tariffRequest.setContractTariffOptions(contractTariffOptions);
        String calledNumber = this.tarifficationNumber;
        tariffRequest.setPhoneTo(calledNumber);
        tariffRequest.setPhoneOriginalTo(this.session.getCalledStationId());
        tariffRequest.setCallType(this.session.getCallType());
        tariffRequest.setOperatorId(this.session.getOperatorId());
        tariffRequest.setPhoneFrom(this.session.getE164CallingStationId());
        long amountForTariff = amount != null ? amount.longValue() : this.session.getSessionTime();
        tariffRequest.serviceCost = new VoiceServiceCost(0, null, null, null, null, amountForTariff);
        tariffRequest.setPortFrom(this.session.getFromPort());
        tariffRequest.setPortTo(this.session.getToPort());
        if (this.accountRuntime instanceof VoiceOperAccountRuntime && (serviceId = ((VoiceOperAccount)(operAccountRuntime = (VoiceOperAccountRuntime)this.accountRuntime).getAccount()).getServiceId()) > 0) {
            ArrayList<VoiceServiceCost> serviceCosts = new ArrayList<VoiceServiceCost>();
            serviceCosts.add((VoiceServiceCost)tariffRequest.serviceCost);
            tariffRequest.getServiceCost().put(serviceId, serviceCosts);
            ((VoiceServiceCost)tariffRequest.serviceCost).serviceId = serviceId;
        }
        TariffModuleTreeSet treeSet = this.accountRuntime.getTariffTreeSet();
        List treeList = treeSet.getTreeList(this.session.getSessionStart().getTime());
        if (logger.isTraceEnabled()) {
            logger.trace("treeSet = {}", (Object)treeSet.toString());
            logger.trace("treeList.size()", (Object)treeList.size());
        }
        try {
            int result = this.calcInternal(tariffContext, round, workerContext, tariffRequest, treeList);
            logger.trace("calcInternal result = {}", (Object)result);
            if (result >= 0) {
                if (result == 0) {
                    this.session.setContractId(this.accountRuntime.getAccount().getContractId());
                    this.contractId = this.accountRuntime.getAccount().getContractId();
                }
                return result;
            }
            if (result < 0 && this.accountRuntime instanceof VoiceAccountRuntime) {
                VoiceAccountRuntime accountRuntimeCl = (VoiceAccountRuntime)this.accountRuntime;
                for (VoiceAccountRuntime.ContractInfo contractInfo : accountRuntimeCl.getSubContracts()) {
                    treeList = contractInfo.tariffTreeSet.getTreeList(this.session.getSessionStart().getTime());
                    result = this.calcInternal(tariffContext, round, workerContext, tariffRequest, treeList);
                    if (tariffContext.isRuntime() && !StatusCache.getInstance().isModuleActiveStatus(moduleId, contractInfo.status) || result < 0) continue;
                    if (result == 0) {
                        this.session.setContractId(contractInfo.contractId);
                        this.contractId = contractInfo.contractId;
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            logger.error(e + "; contractId=" + this.session.getContractId() + "; sessionId=" + this.session.getId());
        }
        return 63;
    }

    private int calcInternal(TariffContext tariffContext, boolean round, VoiceTariffWorkerContext workerContext, VoiceTariffRequest tariffRequest, List<TariffModuleTree> treeList) {
        if (treeList.size() == 0) {
            return 62;
        }
        BigDecimal sessionCost = this.session.getSessionCost();
        boolean priceFound = false;
        for (TariffModuleTree tree : treeList) {
            tree.execute((AbstractTariffRequest)tariffRequest, tariffContext, (ThreadContext)workerContext);
            List serviceCosts = (List)tariffRequest.getServiceCostList();
            if (logger.isTraceEnabled()) {
                logger.trace("serviceCosts.size() = {}", (Object)serviceCosts.size());
            }
            if (tariffRequest.isRejected()) {
                return 44;
            }
            if (serviceCosts.size() == 0) continue;
            priceFound = true;
            int destId = tariffRequest.getDestId();
            if (destId <= 0) {
                return 65;
            }
            this.session.setDestinationId(destId);
            int zoneId = tariffRequest.getZoneId();
            int codeId = tariffRequest.getCodeId();
            int operatorId = tariffRequest.getOperatorId();
            int costMapItemId = tariffRequest.getCostMapItemId();
            this.session.setZoneId(zoneId);
            this.session.setCodeId(codeId);
            this.session.setCostMapItemId(costMapItemId);
            this.session.setOperatorId(operatorId);
            for (VoiceServiceCost cost : serviceCosts) {
                if (cost.serviceId == 0 || cost.cost == null) {
                    if (!(cost.serviceId == 0 ^ cost.cost == null)) continue;
                    return 66;
                }
                SessionAccountAmount accountAmount = this.accountAmountMap.get(cost.serviceId);
                if (accountAmount == null) {
                    accountAmount = new SessionAccountAmount(BigDecimal.ZERO, 0L);
                    this.accountAmountMap.put(cost.serviceId, accountAmount);
                }
                if (round) {
                    this.roundServiceCost(tariffRequest, cost);
                }
                accountAmount.addAccount(cost.cost, tariffContext.mc);
                accountAmount.addAmount(cost.amount);
                sessionCost = sessionCost.add(cost.cost, tariffContext.mc);
                SessionAccountAmount delta = this.getAccountDeltaMap().get(cost.serviceId);
                if (delta == null) {
                    delta = new SessionAccountAmount(cost.cost, cost.amount);
                    this.getAccountDeltaMap().put(cost.serviceId, delta);
                    continue;
                }
                delta.addAmount(cost.amount);
                delta.addAccount(cost.cost, tariffContext.mc);
            }
            if (round) {
                int result = this.roundSessionTime(tariffRequest, serviceCosts, tariffContext.mc, sessionCost);
                if (result > 0) {
                    return result;
                }
            } else {
                this.session.setRoundedSessionTime(this.session.getSessionTime());
                this.session.setSessionCost(sessionCost);
            }
            this.setFirstServiceAndMinuteCost(serviceCosts);
            this.optionsSet = tariffRequest.getOptionSet();
            break;
        }
        if (!priceFound) {
            return -1;
        }
        return 0;
    }

    private void setFirstServiceAndMinuteCost(List<VoiceServiceCost> serviceCosts) {
        if (serviceCosts.size() > 0) {
            VoiceServiceCost cost = serviceCosts.get(0);
            this.session.setServiceId(cost.serviceId);
            this.session.setMinuteCost(cost.secondCost.multiply(new BigDecimal(60)));
        }
    }

    private void roundServiceCost(VoiceTariffRequest tariffRequest, VoiceServiceCost cost) {
        VoiceTariffConfig config = tariffRequest.getConfig();
        if (logger.isDebugEnabled()) {
            logger.debug("roundServiceCost: cost.cost = " + cost.cost + "; config = " + config);
        }
        if (config != null && cost != null) {
            cost.cost = config.roundCost(cost.cost != null ? cost.cost : BigDecimal.ZERO, 5);
        }
    }

    private int roundSessionTime(VoiceTariffRequest tariffRequest, List<VoiceServiceCost> serviceCosts, MathContext mc, BigDecimal sessionCost) {
        long roundTime = this.session.getSessionTime();
        VoiceTariffConfig config = tariffRequest.getConfig();
        if (logger.isDebugEnabled()) {
            logger.debug("session.getSessionTime() = " + this.session.getSessionTime() + "; config = " + config);
        }
        if (config != null && serviceCosts.size() > 0) {
            long delta;
            VoiceServiceCost lastCost = serviceCosts.get(serviceCosts.size() - 1);
            roundTime = config.getRoundTime((int)this.session.getSessionTime());
            long l = delta = config.isUseRound() ? 0L : roundTime - this.session.getSessionTime();
            if (logger.isDebugEnabled()) {
                logger.debug("lastCost = " + lastCost + "; roundTime = " + roundTime + "; delta = " + delta);
            }
            if (delta > 0L) {
                if (lastCost.amount > 0L) {
                    SessionAccountAmount deltaCost;
                    BigDecimal secondCost = lastCost.secondCost;
                    BigDecimal newDeltaCost = config.roundCost(new BigDecimal(lastCost.amount + delta).multiply(lastCost.secondCost), 5);
                    newDeltaCost = newDeltaCost.subtract(lastCost.cost);
                    newDeltaCost.add(this.getAddCost(tariffRequest, roundTime));
                    if (logger.isDebugEnabled()) {
                        logger.debug("secondCost = " + secondCost + "; newDeltaCost = " + newDeltaCost);
                    }
                    sessionCost = sessionCost.add(newDeltaCost, mc);
                    SessionAccountAmount cost = this.accountAmountMap.get(lastCost.serviceId);
                    if (cost != null) {
                        cost.addAccount(newDeltaCost, mc);
                    }
                    if ((deltaCost = this.accountDeltaMap.get(lastCost.serviceId)) == null) {
                        deltaCost = new SessionAccountAmount(newDeltaCost, 0L);
                        this.getAccountDeltaMap().put(lastCost.serviceId, deltaCost);
                    } else {
                        deltaCost.addAccount(newDeltaCost, mc);
                    }
                }
            } else if (delta < 0L && roundTime == 0L) {
                sessionCost = BigDecimal.ZERO;
                this.accountAmountMap.clear();
            } else if (delta < 0L) {
                return 66;
            }
            sessionCost = config.roundCost(sessionCost, 5);
        }
        this.session.setRoundedSessionTime(roundTime);
        this.session.setSessionCost(sessionCost);
        return 0;
    }

    private BigDecimal getAddCost(VoiceTariffRequest tariffRequest, long roundSessionTime) {
        AddCallCostTariffTreeNode addCost = tariffRequest.getAddCost();
        if (!(addCost == null || addCost.nonZero && roundSessionTime <= 0L)) {
            return addCost.cost;
        }
        return BigDecimal.ZERO;
    }

    public long getCalculateAmountDelta() {
        return this.calculateAmountDelta;
    }

    public void setCalculateAmountDelta(long calculateAmountDelta) {
        this.calculateAmountDelta = calculateAmountDelta;
    }

    public Map<Integer, SessionAccountAmount> getAccountDeltaMap() {
        return this.accountDeltaMap;
    }

    public Map<Integer, SessionAccountAmount> getAccountAmountMap() {
        return this.accountAmountMap;
    }

    public static List<VoiceSessionRuntime> toListRuntime(List<VoiceSessionRuntime> session) {
        return null;
    }

    public String getTarifficationNumber() {
        return this.tarifficationNumber;
    }

    public void setTarifficationNumber(String tarifficationNumber) {
        this.tarifficationNumber = tarifficationNumber;
    }

    public boolean isOperSession() {
        return this.isOperSession;
    }

    public VoiceAbtractAccountRuntime<?> getAccountRuntime() {
        return this.accountRuntime;
    }

    public int hashCode() {
        return this.accountRuntime != null ? this.accountRuntime.getAccountId() : 0;
    }

    public VoiceSessionRuntime getParentSession() {
        return this.parentSession;
    }

    public void setParentSession(VoiceSessionRuntime parentSession) {
        this.parentSession = parentSession;
    }

    public Set<Integer> getOptionsSet() {
        return this.optionsSet;
    }
}

