/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.device;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceMap;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceTypeDao;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoiceDeviceRuntimeMap {
    private static final Logger logger = LogManager.getLogger();
    private static Map<Integer, VoiceDeviceRuntimeMap> instances = new HashMap<Integer, VoiceDeviceRuntimeMap>();
    private Setup setup;
    private final int moduleId;
    private volatile Map<Integer, VoiceDeviceRuntime> idMap;

    public static VoiceDeviceRuntimeMap getInstance(Setup setup, int moduleId) throws BGException {
        VoiceDeviceRuntimeMap instance = instances.get(moduleId);
        if (instance == null) {
            instance = new VoiceDeviceRuntimeMap(setup, moduleId);
            instances.put(moduleId, instance);
        }
        return instance;
    }

    private VoiceDeviceRuntimeMap(Setup setup, int moduleId) throws BGException {
        this.moduleId = moduleId;
        this.setup = setup;
    }

    public VoiceDeviceRuntime get(Integer id) {
        return this.idMap.get(id);
    }

    public Collection<VoiceDeviceRuntime> values() {
        return this.idMap.values();
    }

    public synchronized void load(Connection con) throws BGException {
        List types;
        List<VoiceDevice> devices;
        logger.info("(Re)loading VoiceDeviceRuntimeMap");
        GregorianCalendar closePeriod = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)closePeriod);
        Date closePeriodDate = closePeriod.getTime();
        try (VoiceDeviceDao voiceDeviceDao = new VoiceDeviceDao(con, this.moduleId, 0);
             VoiceDeviceTypeDao voiceDeviceTypeDao = new VoiceDeviceTypeDao(con, this.moduleId);){
            devices = voiceDeviceDao.list();
            types = voiceDeviceTypeDao.list();
        }
        HashMap typeMap = new HashMap();
        types.forEach(type -> typeMap.put(type.getId(), type));
        VoiceDeviceMap deviceMap = VoiceDeviceMap.getInstance(this.moduleId);
        deviceMap.reload();
        HashMap<Integer, VoiceDeviceRuntime> idMap = new HashMap<Integer, VoiceDeviceRuntime>();
        for (VoiceDevice device : devices) {
            VoiceDeviceMap.VoiceDeviceMapItem item;
            VoiceDeviceType type2 = (VoiceDeviceType)typeMap.get(device.getDeviceTypeId());
            Object config = null;
            if (Utils.notBlankString((String)device.getConfig())) {
                config = new Preferences(device.getConfig(), "\n");
            }
            if (type2 != null && Utils.notBlankString((String)device.getConfig())) {
                config = config != null ? new Preferences(type2.getConfig(), "\n").inherit((ParameterMap)config) : new Preferences(type2.getConfig(), "\n");
            }
            if ((item = deviceMap.get(device.getId())) == null) {
                if (device != null && device.getDateTo() != null && device.getDateTo().before(closePeriodDate)) continue;
                logger.error("Can't find Device in DeviceMap with id=" + device.getId() + "!");
                continue;
            }
            idMap.put(device.getId(), new VoiceDeviceRuntime(this.setup, this.moduleId, device, type2, null, (ParameterMap)config, item.getDescendantIds(), true));
        }
        final Map<Integer, VoiceDeviceRuntime> oldMap = this.idMap;
        this.idMap = idMap;
        if (oldMap != null) {
            new Thread("deviceRntm-destroy"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    for (VoiceDeviceRuntime deviceRuntime : oldMap.values()) {
                        deviceRuntime.getOmInstances().lock();
                        deviceRuntime.getOmInstances().unlock();
                    }
                    for (VoiceDeviceRuntime deviceRuntime : oldMap.values()) {
                        deviceRuntime.getOmInstances().lock();
                        try {
                            deviceRuntime.getOmInstances().destroy();
                        }
                        finally {
                            deviceRuntime.getOmInstances().unlock();
                        }
                    }
                }
            }.start();
        }
    }
}

