/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.admin.DialogEditDate;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountEditor;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountNumberForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class VoiceAccountPanel
extends BGUPanel {
    public static final KeyValue COLUMN_TITLE = new KeyValue("title", "\u0410\u043a\u043a\u0430\u0443\u043d\u0442");
    public static final KeyValue COLUMN_NUMBER = new KeyValue("number", "\u041d\u043e\u043c\u0435\u0440");
    private VoiceDeviceService deviceService = null;
    private VoiceAccountService accountService = null;
    private VoiceAccount selectedVoiceAccount = null;
    private BGUTable accountTable = null;
    private BGTextField filterValue = null;
    private BGControlPanelDateNoB filterDate = null;
    private BGUComboBox<KeyValue> filterColumn = null;
    private BGUComboBox<IdTitle> filterStatus = null;
    private BGUComboBox<IdTitle> filterDeviceState = null;
    private List<VoiceAccount> voiceAccounts = null;
    private VoiceAccountTableModel accountTableModel = null;
    Map<Integer, ContractObject> objectMap = new HashMap<Integer, ContractObject>();
    private JPopupMenu popupMenu = null;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            int contractId = ((ClientContext)VoiceAccountPanel.this.getContext()).getContractId();
            int contractObjectId = ((ClientContext)VoiceAccountPanel.this.getContext()).getObjectId();
            List contractObjectList = ((ContractObjectService)((ClientContext)VoiceAccountPanel.this.getContext()).getPort(ContractObjectService.class, 0)).contractObjectList(contractId);
            VoiceAccountPanel.this.objectMap.putAll(contractObjectList.stream().filter(o -> contractObjectId > 0 && o.getId() == contractObjectId || contractObjectId == 0).collect(Collectors.toMap(v -> v.getId(), v -> v)));
            if (VoiceAccountPanel.this.accountTableModel != null && VoiceAccountPanel.this.accountTable != null) {
                VoiceAccountPanel.this.voiceAccounts = VoiceAccountPanel.this.getVoiceAccountService().voiceAccountList(contractId, contractObjectId, null);
                VoiceAccountPanel.this.doFilterTable();
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAccountAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            List selectedAccounts = VoiceAccountPanel.this.accountTableModel.getSelectedRows();
            if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)BGClient.getFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", 0) == 0) {
                if (selectedAccounts.size() > 1) {
                    VoiceAccountPanel.this.getVoiceAccountService().voiceAccountListDelete(selectedAccounts.stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()));
                } else {
                    VoiceAccountPanel.this.getVoiceAccountService().voiceAccountDelete(((VoiceAccount)selectedAccounts.get(0)).getId());
                }
                VoiceAccountPanel.this.performAction("refresh");
            }
        }
    };

    protected void jbInit() throws Exception {
        try {
            Contract contract = ((ContractService)((ClientContext)this.getContext()).getPort(ContractService.class, 0)).contractGet(((ClientContext)this.getContext()).getContractId());
            if (contract.isIndependSub() && VoiceCommonUtils.agetModeOn((Preferences)ClientSetup.getInstance())) {
                JLabel label = new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b, \u044d\u0442\u043e \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u043c", 0);
                this.removeAll();
                this.add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                return;
            }
        }
        catch (BGException e) {
            ((ClientContext)this.getContext()).processException((Throwable)e);
        }
        BGEditor editor = new BGEditor("table");
        editor.addForm((JComponent)this.getTablePanel(), (Object)"table");
        editor.addForm((JComponent)((Object)new VoiceAccountEditor(this, this.getVoiceAccountService())));
        this.setLayout(new BorderLayout());
        this.add((Component)editor, "Center");
        BGSwingUtilites.handleEdit((JTable)this.accountTable, (AbstractBGUPanel)editor);
    }

    private JPanel getTablePanel() {
        this.accountTableModel = new VoiceAccountTableModel();
        this.accountTable = new BGUTable((TableModel)((Object)this.accountTableModel));
        this.accountTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && ((VoiceAccount)VoiceAccountPanel.this.accountTableModel.getSelectedRow()).getChildren() == null) {
                    VoiceAccountPanel.this.getPopupMenu().show((Component)VoiceAccountPanel.this.accountTable, event.getX(), event.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.accountTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.filterColumn = new BGUComboBox();
        this.filterColumn.addItem((Object)COLUMN_TITLE);
        this.filterColumn.addItem((Object)COLUMN_NUMBER);
        this.filterValue = new BGTextField(10);
        this.filterValue.setHorizontalAlignment(0);
        this.filterValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }
        });
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.doFilterTable();
            }
        };
        this.filterStatus = new BGUComboBox();
        this.filterStatus.addItem((Object)new IdTitle(-1, "\u043b\u044e\u0431\u043e\u0439"));
        this.filterStatus.addItem((Object)new IdTitle(0, "\u043e\u0442\u043a\u0440\u044b\u0442"));
        this.filterStatus.addItem((Object)new IdTitle(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.filterStatus.addItemListener(listener);
        this.filterDeviceState = new BGUComboBox();
        this.filterDeviceState.addItem((Object)new IdTitle(-2, "\u043b\u044e\u0431\u043e\u0435"));
        this.filterDeviceState.addItem((Object)new IdTitle(-1, "\u0443\u0434\u0430\u043b\u0435\u043d"));
        this.filterDeviceState.addItem((Object)new IdTitle(1, "\u0432\u043a\u043b\u044e\u0447\u0435\u043d"));
        this.filterDeviceState.addItem((Object)new IdTitle(0, "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d"));
        this.filterDeviceState.addItemListener(listener);
        this.filterDate = new BGControlPanelDateNoB();
        this.filterDate.setLocalDate(LocalDate.now());
        this.filterDate.setButtonNow(true);
        this.filterDate.addPropertyChangeListener("date", e -> this.doFilterTable());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.filterColumn, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.filterValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterStatus, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterDeviceState, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterDate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void doFilterTable() {
        if (this.voiceAccounts != null && this.accountTableModel != null) {
            KeyValue keyValue = (KeyValue)this.filterColumn.getSelectedItem();
            String value = this.filterValue.getText();
            int status = ((IdTitle)this.filterStatus.getSelectedItem()).getId();
            int state = ((IdTitle)this.filterDeviceState.getSelectedItem()).getId();
            LocalDate date = this.filterDate.getLocalDate();
            ArrayList<VoiceAccount> list = new ArrayList<VoiceAccount>();
            for (VoiceAccount voiceAccount : this.voiceAccounts) {
                boolean add = true;
                if (!value.isEmpty()) {
                    switch (keyValue.getKey()) {
                        case "title": {
                            add = voiceAccount.getTitle().contains(value);
                            break;
                        }
                        case "number": {
                            add = String.valueOf(voiceAccount.getNumber()).contains(value);
                            break;
                        }
                    }
                }
                if (add && status > -1) {
                    boolean bl = add = voiceAccount.getStatus() == status;
                }
                if (add && state > -2) {
                    boolean bl = add = voiceAccount.getDeviceState() == state;
                }
                if (add && date != null) {
                    add = TimeUtils.dateInRange((Date)TimeUtils.convertLocalDateToDate((LocalDate)date), (Date)voiceAccount.getDateFrom(), (Date)voiceAccount.getDateTo());
                }
                if (!add) continue;
                list.add(voiceAccount);
            }
            this.accountTableModel.setData(list);
        }
    }

    private VoiceDeviceService getVoiceDeviceService() {
        if (this.deviceService == null) {
            this.deviceService = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
        }
        return this.deviceService;
    }

    private VoiceAccountService getVoiceAccountService() {
        if (this.accountService == null) {
            this.accountService = (VoiceAccountService)((ClientContext)this.getContext()).getPort(VoiceAccountService.class);
        }
        return this.accountService;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            JMenuItem duplicateForNumber = new JMenuItem("\u041f\u0440\u043e\u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043d\u043e\u043c\u0435\u0440\u043e\u0432");
            duplicateForNumber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VoiceAccountPanel.this.accountTableModel.getSelectedRow() == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        return;
                    }
                    VoiceAccountPanel.this.selectedVoiceAccount = (VoiceAccount)VoiceAccountPanel.this.accountTableModel.getSelectedRow();
                    VoiceAccountPanel.this.dublicateEditorWindow(this);
                }
            });
            JMenuItem editDateItem = new JMenuItem("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u0442\u0443");
            editDateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List selectedAccounts = VoiceAccountPanel.this.accountTableModel.getSelectedRows();
                    if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        return;
                    }
                    VoiceAccountPanel.this.changeDateSelectedAccounts(selectedAccounts);
                }
            });
            JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            deleteItem.addActionListener(e -> this.performAction("delete"));
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(duplicateForNumber);
            this.popupMenu.add(editDateItem);
            this.popupMenu.add(deleteItem);
        }
        return this.popupMenu;
    }

    private void dublicateEditorWindow(ActionListener listener) {
        VoiceAccountNumberForm numberForm = new VoiceAccountNumberForm((ClientContext)this.getContext(), listener);
        PhoneCategory rootCat = null;
        try {
            rootCat = ((PhoneResourceService)((ClientContext)this.getContext()).getPort(PhoneResourceService.class)).phoneCategoryRoot();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        numberForm.treeModel.setData(rootCat);
        numberForm.treeModel.setSelectedRow(0);
        numberForm.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("voice.resource.ip.free.max", 100));
        numberForm.setVoiceAccountPanel(this);
        new DialogDuplicate(numberForm);
    }

    protected void createNewCopyVoiceAccount(List<Long> selectedNumbers) {
        ArrayList<VoiceAccount> createAccounts = new ArrayList<VoiceAccount>();
        String comment = "\u0421\u043e\u0437\u0434\u0430\u043d \u043f\u0430\u043a\u0435\u0442\u043d\u043e";
        for (Long number : selectedNumbers) {
            VoiceAccount account = new VoiceAccount();
            try {
                account = (VoiceAccount)this.selectedVoiceAccount.clone();
                account.setId(-1);
                account.setNumber(number.longValue());
                account.setComment(comment);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            createAccounts.add(account);
        }
        try {
            for (VoiceAccount account : createAccounts) {
                this.getVoiceAccountService().voiceAccountUpdate(account);
            }
            this.performAction("refresh");
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    BGTableModel<VoiceAccount> getAccountTableModel() {
        return this.accountTableModel;
    }

    private void changeDateSelectedAccounts(final List<VoiceAccount> selectedAccounts) {
        final DialogEditDate dialogEditDate = new DialogEditDate();
        dialogEditDate.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date dateTo;
                Date dateFrom = dialogEditDate.fromDate.getDate();
                if (dateFrom.after(dateTo = dialogEditDate.toDate.getDate())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
                    return;
                }
                for (VoiceAccount account : selectedAccounts) {
                    account.setDateFrom(dateFrom);
                    if (dateTo != null) {
                        account.setDateTo(dateTo);
                    }
                    try {
                        VoiceAccountPanel.this.getVoiceAccountService().voiceAccountUpdate(account);
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                dialogEditDate.dispose();
                VoiceAccountPanel.this.performAction("refresh");
            }
        });
    }

    class VoiceAccountTableModel
    extends BGTableModel<VoiceAccount> {
        private Map<Integer, String> deviceTitles;
        private Map<Integer, String> typeTypes;
        private Directory<VoiceAccountType> directory;

        public VoiceAccountTableModel() {
            super(VoiceAccountTableModel.class.getName());
            this.deviceTitles = new HashMap<Integer, String>();
            this.typeTypes = new HashMap<Integer, String>();
            this.directory = null;
            try {
                this.directory = ((ClientContext)VoiceAccountPanel.this.getContext()).getDirectory(VoiceAccountType.class);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn(COLUMN_TITLE.getValue(), -1, -1, -1, COLUMN_TITLE.getKey(), true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, -1, -1, "deviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "typeTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn(COLUMN_NUMBER.getValue(), 120, 120, -1, COLUMN_NUMBER.getKey(), true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 100, 100, "status", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 100, 100, 100, "deviceState", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, 160, -1, "comment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", null, 80, 160, -1, "object", true, false, false, null);
        }

        public Object getValue(VoiceAccount val, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "title": {
                    return Utils.maskNull((String)val.getTitle());
                }
                case "deviceTitle": {
                    Integer deviceId = val.getDeviceId();
                    if (!this.deviceTitles.containsKey(deviceId)) {
                        this.deviceTitles.put(deviceId, ((VoiceDevice)VoiceAccountPanel.this.getVoiceDeviceService().deviceGet(deviceId.intValue())).getTitle());
                    }
                    return this.deviceTitles.get(deviceId);
                }
                case "typeTitle": {
                    Integer typeId = val.getTypeId();
                    if (!this.typeTypes.containsKey(typeId)) {
                        this.typeTypes.put(typeId, ((VoiceAccountType)this.directory.get(typeId.intValue())).getTitle());
                    }
                    return this.typeTypes.get(typeId);
                }
                case "period": {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                case "status": {
                    switch (val.getStatus()) {
                        case 0: {
                            return "\u0430\u043a\u0442\u0438\u0432\u0435\u043d";
                        }
                        case 2: {
                            return "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                        }
                    }
                    return "---";
                }
                case "deviceState": {
                    switch (val.getDeviceState()) {
                        case -1: {
                            return "\u0443\u0434\u0430\u043b\u0435\u043d";
                        }
                        case 1: {
                            return "\u0432\u043a\u043b\u044e\u0447\u0435\u043d";
                        }
                        case 0: {
                            return "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
                        }
                    }
                    return "---";
                }
                case "object": {
                    ContractObject obj = VoiceAccountPanel.this.objectMap.get(val.getContractObjectId());
                    return obj != null ? obj.getTitle() : "";
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class DialogDuplicate
    extends BGDialog {
        public DialogDuplicate(VoiceAccountNumberForm panel) {
            this.jbInit(panel);
        }

        public void jbInit(VoiceAccountNumberForm panel) {
            this.setTitle("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432");
            this.setSize(1000, 800);
            this.setResizable(true);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            panel.setSize(1000, 800);
            this.add((Component)((Object)panel));
            this.setLocationRelativeTo((Component)BGClient.getFrame());
            this.setVisible(true);
        }
    }
}

