/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.service.ServiceService;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceBaseAccountEditor;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceOperAccountPanel;
import ru.bitel.bgbilling.modules.voice.client.device.VoiceDevicePanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccountType;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class VoiceOperAccountEditorForm
extends VoiceBaseAccountEditor {
    private static final String ACCOUNT_TYPE_CHANGED_ACTION = "account_type_changed";
    private VoiceBaseAccountEditor.ParamRowData paramDevice = new VoiceBaseAccountEditor.ParamRowData("device", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", "");
    private VoiceBaseAccountEditor.ParamRowData paramCallType = new VoiceBaseAccountEditor.ParamRowData("callType", "\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430", "");
    private VoiceBaseAccountEditor.ParamRowData paramService = new VoiceBaseAccountEditor.ParamRowData("service", "\u0423\u0441\u043b\u0443\u0433\u0430", "");
    private VoiceBaseAccountEditor.ParamRowData paramPortFrom = new VoiceBaseAccountEditor.ParamRowData("portFrom", "\u0421 \u043f\u043e\u0440\u0442\u043e\u0432", "");
    private VoiceBaseAccountEditor.ParamRowData paramPortTo = new VoiceBaseAccountEditor.ParamRowData("portTo", "\u041d\u0430 \u043f\u043e\u0440\u0442\u044b", "");
    private VoiceBaseAccountEditor.ParamRowData paramPortFromRegexp = new VoiceBaseAccountEditor.ParamRowData("portFromRegexp", "\u0421 \u043f\u043e\u0440\u0442\u043e\u0432 Regexp", "");
    private VoiceBaseAccountEditor.ParamRowData paramPortToRegexp = new VoiceBaseAccountEditor.ParamRowData("portToRegexp", "\u041d\u0430 \u043f\u043e\u0440\u0442\u044b Regexp", "");
    private VoiceBaseAccountEditor.ParamRowData paramRegexpA = new VoiceBaseAccountEditor.ParamRowData("regexpA", "Regexp A", "");
    private VoiceBaseAccountEditor.ParamRowData paramNoRegexpA = new VoiceBaseAccountEditor.ParamRowData("noRegexpA", "No Regexp A", "");
    private VoiceBaseAccountEditor.ParamRowData paramRegexpB = new VoiceBaseAccountEditor.ParamRowData("regexpB", "Regexp B", "");
    private VoiceBaseAccountEditor.ParamRowData paramNoRegexpB = new VoiceBaseAccountEditor.ParamRowData("noRegexpB", "No Regexp B", "");
    private List<IdTitle> callTypes = Arrays.asList(new IdTitle(0, "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"), new IdTitle(1, "\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435"), new IdTitle(2, "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
    private List<IdTitle> services = new ArrayList<IdTitle>();
    private VoiceOperAccountService accountService;
    private Directory<VoiceOperAccountType> accountTypeDirectory;
    private ServiceService serviceService;
    private VoiceOperAccountPanel parentPanel;
    private VoiceOperAccount currentAccount;
    private BGUComboBox<VoiceOperAccountType> accountTypeCombobox = new BGUComboBox();
    private BGTextField title = new BGTextField();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private VoiceDeviceService deviceService = null;
    AbstractBGUPanel.DefaultAction newAccountAction = new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceOperAccountEditorForm.this.currentAccount = new VoiceOperAccount();
            VoiceOperAccountEditorForm.this.currentAccount.setContractId(((ClientContext)VoiceOperAccountEditorForm.this.getContext()).getContractId());
            VoiceOperAccountEditorForm.this.performActionOpen();
            VoiceOperAccountEditorForm.this.accountTypeCombobox.setEnabled(true);
            VoiceOperAccountEditorForm.this.accountTypeCombobox.setSelectedIndex(VoiceOperAccountEditorForm.this.accountTypeCombobox.getItemCount() > 1 ? 1 : 0);
            VoiceOperAccountEditorForm.this.period.setLocalDateFrom(LocalDate.now());
            VoiceOperAccountEditorForm.this.period.setLocalDateTo(null);
            VoiceOperAccountEditorForm.this.title.setText("");
            VoiceOperAccountEditorForm.this.paramDevice.reset();
            VoiceOperAccountEditorForm.this.paramCallType.reset();
            VoiceOperAccountEditorForm.this.paramService.reset();
            VoiceOperAccountEditorForm.this.params.forEach(VoiceBaseAccountEditor.ParamRowData::reset);
        }
    };
    AbstractBGUPanel.DefaultAction editAccountAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceOperAccount row = (VoiceOperAccount)VoiceOperAccountEditorForm.this.parentPanel.getAccountTableModel().getSelectedRow();
            if (row != null) {
                VoiceOperAccountEditorForm.this.currentAccount = VoiceOperAccountEditorForm.this.accountService.voiceOperAccountGet(row.getId());
            }
            if (VoiceOperAccountEditorForm.this.currentAccount == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            VoiceOperAccountEditorForm.this.accountTypeCombobox.setEnabled(false);
            VoiceOperAccountEditorForm.this.performActionOpen();
            VoiceOperAccountType accountType = (VoiceOperAccountType)VoiceOperAccountEditorForm.this.accountTypeDirectory.get(VoiceOperAccountEditorForm.this.currentAccount.getTypeId());
            if (accountType != null) {
                VoiceOperAccountEditorForm.this.accountTypeCombobox.setSelectedItem((Object)accountType);
            }
            VoiceOperAccountEditorForm.this.accountTypeCombobox.setEnabled(false);
            VoiceOperAccountEditorForm.this.period.setDateFrom(VoiceOperAccountEditorForm.this.currentAccount.getDateFrom());
            VoiceOperAccountEditorForm.this.period.setDateTo(VoiceOperAccountEditorForm.this.currentAccount.getDateTo());
            VoiceOperAccountEditorForm.this.title.setText(VoiceOperAccountEditorForm.this.currentAccount.getTitle());
            VoiceOperAccountEditorForm.this.paramDevice.setValue(((VoiceDevice)VoiceOperAccountEditorForm.this.deviceService.deviceGet(VoiceOperAccountEditorForm.this.currentAccount.getDeviceId())).getTitle());
            VoiceOperAccountEditorForm.this.paramCallType.setValue(VoiceOperAccountEditorForm.this.callTypes.stream().filter(c -> c.getId() == VoiceOperAccountEditorForm.this.currentAccount.getCallType()).findFirst().orElse(VoiceOperAccountEditorForm.this.callTypes.get(0)).getTitle());
            VoiceOperAccountEditorForm.this.paramCallType.setId(VoiceOperAccountEditorForm.this.currentAccount.getCallType());
            VoiceOperAccountEditorForm.this.paramService.setValue(VoiceOperAccountEditorForm.this.services.stream().filter(a -> a.getId() == VoiceOperAccountEditorForm.this.currentAccount.getServiceId()).findFirst().orElse(VoiceOperAccountEditorForm.this.services.get(0)).getTitle());
            VoiceOperAccountEditorForm.this.paramService.setId(VoiceOperAccountEditorForm.this.currentAccount.getServiceId());
            VoiceOperAccountEditorForm.this.paramPortFrom.setValue(VoiceOperAccountEditorForm.this.currentAccount.getFromPorts());
            VoiceOperAccountEditorForm.this.paramPortTo.setValue(VoiceOperAccountEditorForm.this.currentAccount.getToPorts());
            VoiceOperAccountEditorForm.this.paramPortFromRegexp.setValue(VoiceOperAccountEditorForm.this.currentAccount.getRegexpFromPorts());
            VoiceOperAccountEditorForm.this.paramPortToRegexp.setValue(VoiceOperAccountEditorForm.this.currentAccount.getRegexpToPorts());
            VoiceOperAccountEditorForm.this.paramRegexpA.setValue(VoiceOperAccountEditorForm.this.currentAccount.getRegexpA());
            VoiceOperAccountEditorForm.this.paramNoRegexpA.setValue(VoiceOperAccountEditorForm.this.currentAccount.getRegexpA());
            VoiceOperAccountEditorForm.this.paramRegexpB.setValue(VoiceOperAccountEditorForm.this.currentAccount.getRegexpB());
            VoiceOperAccountEditorForm.this.paramNoRegexpB.setValue(VoiceOperAccountEditorForm.this.currentAccount.getNoRegexpB());
        }
    };
    AbstractBGUPanel.DefaultAction deleteAccountAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            VoiceOperAccount selectedAccount = (VoiceOperAccount)VoiceOperAccountEditorForm.this.parentPanel.getAccountTableModel().getSelectedRow();
            if (selectedAccount == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", 0) == 0) {
                VoiceOperAccountEditorForm.this.accountService.voiceOperAccountDelete(selectedAccount.getId());
                VoiceOperAccountEditorForm.this.performActionClose();
            }
        }
    };
    AbstractBGUPanel.DefaultAction okAction = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (VoiceOperAccountEditorForm.this.paramService.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return;
            }
            if (VoiceOperAccountEditorForm.this.paramCallType.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430!");
                return;
            }
            VoiceOperAccountType selectedType = (VoiceOperAccountType)VoiceOperAccountEditorForm.this.accountTypeCombobox.getSelectedItem();
            if (selectedType != null) {
                if (selectedType.getId() == 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430!");
                    return;
                }
                VoiceOperAccountEditorForm.this.currentAccount.setTypeId(selectedType.getId());
            }
            VoiceOperAccountEditorForm.this.currentAccount.setDateFrom(VoiceOperAccountEditorForm.this.period.getDateFrom());
            VoiceOperAccountEditorForm.this.currentAccount.setDateTo(VoiceOperAccountEditorForm.this.period.getDateTo());
            VoiceOperAccountEditorForm.this.currentAccount.setFromPorts(VoiceOperAccountEditorForm.this.paramPortFrom.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setToPorts(VoiceOperAccountEditorForm.this.paramPortTo.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setRegexpFromPorts(VoiceOperAccountEditorForm.this.paramPortFromRegexp.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setRegexpToPorts(VoiceOperAccountEditorForm.this.paramPortToRegexp.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setRegexpA(VoiceOperAccountEditorForm.this.paramRegexpA.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setNoRegexpA(VoiceOperAccountEditorForm.this.paramNoRegexpA.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setRegexpB(VoiceOperAccountEditorForm.this.paramRegexpB.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setNoRegexpB(VoiceOperAccountEditorForm.this.paramNoRegexpB.getValue());
            VoiceOperAccountEditorForm.this.currentAccount.setTitle(VoiceOperAccountEditorForm.this.title.getText());
            VoiceOperAccountEditorForm.this.currentAccount.setCallType((byte)VoiceOperAccountEditorForm.this.paramCallType.getId());
            VoiceOperAccountEditorForm.this.currentAccount.setServiceId(VoiceOperAccountEditorForm.this.paramService.getId());
            VoiceOperAccountEditorForm.this.accountService.voiceOperAccountUpdate(VoiceOperAccountEditorForm.this.currentAccount);
            VoiceOperAccountEditorForm.this.performActionClose();
        }
    };
    AbstractBGUPanel.DefaultAction accountTypeChangedAction = new AbstractBGUPanel.DefaultAction("account_type_changed", "\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceOperAccountType selectedAccountType = (VoiceOperAccountType)VoiceOperAccountEditorForm.this.accountTypeCombobox.getSelectedItem();
            if (selectedAccountType == null) {
                return;
            }
            VoiceOperAccountEditorForm.this.paramTableModel.deleteRows();
            VoiceOperAccountEditorForm.this.paramTableModel.getRows().add(VoiceOperAccountEditorForm.this.paramDevice);
            VoiceOperAccountEditorForm.this.paramTableModel.getRows().add(VoiceOperAccountEditorForm.this.paramCallType);
            VoiceOperAccountEditorForm.this.paramTableModel.getRows().add(VoiceOperAccountEditorForm.this.paramService);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedFromPorts(), VoiceOperAccountEditorForm.this.paramPortFrom);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedToPorts(), VoiceOperAccountEditorForm.this.paramPortTo);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedRegexpFromPorts(), VoiceOperAccountEditorForm.this.paramPortFromRegexp);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedRegexpToPorts(), VoiceOperAccountEditorForm.this.paramPortToRegexp);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedRegexpA(), VoiceOperAccountEditorForm.this.paramRegexpA);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedNoRegexpA(), VoiceOperAccountEditorForm.this.paramNoRegexpA);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedRegexpB(), VoiceOperAccountEditorForm.this.paramRegexpB);
            VoiceOperAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedNoRegexpB(), VoiceOperAccountEditorForm.this.paramNoRegexpB);
        }
    };

    public VoiceOperAccountEditorForm(VoiceOperAccountPanel parentPanel) throws BGException {
        this.setLayout(new BorderLayout());
        this.parentPanel = parentPanel;
        this.paramTableModel = new VoiceBaseAccountEditor.ParamTableModel();
        this.params = Arrays.asList(this.paramCallType, this.paramService, this.paramPortFrom, this.paramPortTo, this.paramPortFromRegexp, this.paramPortToRegexp, this.paramRegexpA, this.paramNoRegexpA, this.paramRegexpB, this.paramNoRegexpB);
        this.accountService = (VoiceOperAccountService)((ClientContext)this.getContext()).getPort(VoiceOperAccountService.class);
        this.accountTypeDirectory = ((ClientContext)this.getContext()).getDirectory(VoiceOperAccountType.class);
        this.serviceService = (ServiceService)((ClientContext)this.getContext()).getPort(ServiceService.class, 0);
        this.deviceService = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
    }

    protected void jbInit() throws Exception {
        ActionListener editorsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if ("device.selected".equals(command)) {
                    VoiceDevicePanel panel = (VoiceDevicePanel)((Object)e.getSource());
                    VoiceDevice selectedDevice = (VoiceDevice)panel.getSelectedDevice();
                    VoiceOperAccountEditorForm.this.currentAccount.setDeviceId(selectedDevice.getId());
                    VoiceOperAccountEditorForm.this.paramDevice.value = VoiceOperAccountEditorForm.this.getDeviceName(selectedDevice);
                }
                ((BGUPanel)e.getSource()).performActionClose();
            }
        };
        BGEditor editor = new BGEditor("main");
        editor.addForm((JComponent)this.createMainPanel(), (Object)"main");
        editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)new VoiceDevicePanel((ClientContext)this.getContext(), 2, editorsListener)), (String)"\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        this.add((Component)editor, "Center");
    }

    private JPanel createMainPanel() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    VoiceBaseAccountEditor.ParamRowData paramRowData = (VoiceBaseAccountEditor.ParamRowData)VoiceOperAccountEditorForm.this.paramTableModel.getSelectedRow();
                    if (VoiceOperAccountEditorForm.this.paramDevice.equals(paramRowData)) {
                        VoiceOperAccountEditorForm.this.performAction("device.select", String.valueOf(VoiceOperAccountEditorForm.this.currentAccount.getDeviceId()));
                    }
                    VoiceOperAccountEditorForm.this.paramTableModel.fireTableDataChanged();
                }
            }
        };
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(font.deriveFont(font.getSize2D() + 2.0f));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        BGUTable paramTable = new BGUTable((TableModel)((Object)this.paramTableModel)){

            public TableCellEditor getCellEditor(int row, int column) {
                VoiceBaseAccountEditor.ParamRowData data = (VoiceBaseAccountEditor.ParamRowData)VoiceOperAccountEditorForm.this.paramTableModel.getRows().get(row);
                if (this.convertColumnIndexToModel(column) == 1) {
                    if (VoiceOperAccountEditorForm.this.paramCallType.equals(data)) {
                        return new ParamCellEditor(new JComboBox<IdTitle>(), VoiceOperAccountEditorForm.this.callTypes);
                    }
                    if (VoiceOperAccountEditorForm.this.paramService.equals(data)) {
                        return new ParamCellEditor(new JComboBox<IdTitle>(), VoiceOperAccountEditorForm.this.services);
                    }
                }
                return super.getCellEditor(row, column);
            }
        };
        paramTable.setFont((Font)font);
        paramTable.setRowHeight(fontHeight);
        paramTable.setSelectionMode(0);
        paramTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        paramTable.addMouseListener((MouseListener)mouseAdapter);
        paramTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    VoiceOperAccountEditorForm.this.deleteParamValue();
                }
            }
        });
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)paramTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        this.accountTypeCombobox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.performAction(ACCOUNT_TYPE_CHANGED_ACTION);
            }
        });
        return mainPanel;
    }

    private JPanel getTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapBorder(this.accountTypeCombobox, (String)"\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JComponent)this.title, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 0, 3, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 0, 3, 3), 0, 0));
        return panel;
    }

    public void performActionClose() {
        this.parentPanel.performAction("refresh");
        super.performActionClose();
    }

    public void performActionOpen() {
        try {
            ArrayList<VoiceOperAccountType> accountTypes = new ArrayList<VoiceOperAccountType>();
            VoiceOperAccountType emptyType = new VoiceOperAccountType();
            emptyType.setTitle("----------");
            accountTypes.add(emptyType);
            accountTypes.addAll(this.accountTypeDirectory.list());
            this.accountTypeCombobox.setData(accountTypes);
            this.services.clear();
            this.services.add(new IdTitle(0, "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430"));
            this.serviceService.serviceList(((ClientContext)this.getContext()).getModuleId()).forEach(a -> this.services.add(new IdTitle(a.getId(), a.getTitle())));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        super.performActionOpen();
    }

    @Override
    protected boolean setValueFromIdTitle(VoiceBaseAccountEditor.ParamRowData paramRowData) {
        return paramRowData.equals(this.paramCallType) || paramRowData.equals(this.paramService);
    }

    class ParamCellEditor
    extends DefaultCellEditor {
        private List<IdTitle> data;

        public ParamCellEditor(JComboBox<IdTitle> comboBox, List<IdTitle> data) {
            super(comboBox);
            this.data = null;
            this.data = data;
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.data.forEach(a -> comboBox.addItem(a));
            comboBox.setSelectedItem(this.data.stream().filter(a -> a.getTitle().equals(value)).findFirst().orElse(this.data.get(0)));
            return comboBox;
        }
    }
}

