/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapEditorForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class VoiceCostMapPanel
extends BGUPanel {
    private static final String EDITOR_MODE = "editor";
    private static final String TABLE_MODE = "table";
    private CardLayout layout = new CardLayout();
    private BGUTable costMapTable;
    private CostMapTableMogel costMapTableModel;
    private JPanel tablePanel = new JPanel(new GridBagLayout());
    private VoiceCostMapService costMapService;
    private VoiceCostMapEditorForm costMapEditor;
    private BGUComboBox<VoiceOperator> operators = new BGUComboBox();
    private VoiceOperatorService operService;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            this.refreshOperators();
            VoiceCostMapPanel.this.costMapTableModel.setData(VoiceCostMapPanel.this.costMapService.voiceCostMapList(VoiceCostMapPanel.this.getOperatorId()));
        }

        private void refreshOperators() throws BGException {
            int selectedIndex = VoiceCostMapPanel.this.operators.getSelectedIndex();
            if (selectedIndex <= 0) {
                selectedIndex = 0;
            }
            List operList = VoiceCostMapPanel.this.operService.voiceOperatorList();
            operList.add(0, new VoiceOperator(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
            VoiceCostMapPanel.this.operators.setData(operList);
            if (selectedIndex < VoiceCostMapPanel.this.operators.getItemCount()) {
                VoiceCostMapPanel.this.operators.setSelectedIndex(selectedIndex);
            }
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (VoiceCostMapPanel.this.isCurrentEditorCard()) {
                VoiceCostMapPanel.this.costMapEditor.performAction("newItem");
            } else {
                VoiceCostMapPanel.this.costMapEditor.setCostMap(new VoiceCostMap());
                VoiceCostMapPanel.this.costMapEditor.performAction("new");
                VoiceCostMapPanel.this.layout.show((Container)((Object)VoiceCostMapPanel.this), VoiceCostMapPanel.EDITOR_MODE);
            }
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (VoiceCostMapPanel.this.isCurrentEditorCard()) {
                VoiceCostMapPanel.this.costMapEditor.performAction("editItem");
            } else {
                VoiceCostMap currentCostMap = (VoiceCostMap)VoiceCostMapPanel.this.costMapTableModel.getSelectedRow();
                if (currentCostMap == null) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapPanel.this.costMapTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                    return;
                }
                VoiceCostMapPanel.this.costMapEditor.setCostMap(currentCostMap);
                VoiceCostMapPanel.this.costMapEditor.performAction("edit");
                VoiceCostMapPanel.this.layout.show((Container)((Object)VoiceCostMapPanel.this), VoiceCostMapPanel.EDITOR_MODE);
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (VoiceCostMapPanel.this.isCurrentEditorCard()) {
                VoiceCostMapPanel.this.costMapEditor.performAction("deleteItem");
            } else {
                VoiceCostMap selectedCostMap = (VoiceCostMap)VoiceCostMapPanel.this.costMapTableModel.getSelectedRow();
                if (selectedCostMap == null) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapPanel.this.costMapTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d " + selectedCostMap.getTitle() + "?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    VoiceCostMapPanel.this.costMapService.voiceCostMapDelete(selectedCostMap.getId());
                    VoiceCostMapPanel.this.performAction("refresh");
                }
            }
        }
    };

    protected void jbInit() throws Exception {
        this.costMapEditor = new VoiceCostMapEditorForm((ClientContext)this.getContext(), this);
        this.costMapService = (VoiceCostMapService)((ClientContext)this.getContext()).getPort(VoiceCostMapService.class);
        this.operService = (VoiceOperatorService)((ClientContext)this.getContext()).getPort(VoiceOperatorService.class);
        JPanel operPanel = new JPanel(new GridBagLayout());
        operPanel.add((Component)this.operators, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.setLayout(this.layout);
        this.add(this.tablePanel, TABLE_MODE);
        this.add((Component)((Object)this.costMapEditor), EDITOR_MODE);
        this.costMapTableModel = new CostMapTableMogel(CostMapTableMogel.class.getName());
        this.costMapTable = new BGUTable((TableModel)((Object)this.costMapTableModel));
        this.tablePanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)operPanel, (String)"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.tablePanel.add((Component)new JScrollPane((Component)this.costMapTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.costMapTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceCostMapPanel.this.performAction("edit");
                }
            }
        });
        this.layout.show((Container)((Object)this), TABLE_MODE);
        this.operators.addActionListener(e -> this.performAction("refresh"));
    }

    public void switchToTableMode() {
        this.layout.show((Container)((Object)this), TABLE_MODE);
    }

    private boolean isCurrentEditorCard() {
        boolean result = false;
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof VoiceCostMapEditorForm) || !comp.isVisible()) continue;
            result = true;
        }
        return result;
    }

    public int getOperatorId() {
        return ((VoiceOperator)this.operators.getSelectedItem()).getId();
    }

    class CostMapTableMogel
    extends BGTableModel<VoiceCostMap> {
        public CostMapTableMogel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

