<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<!-- получение нового агента -->
<xsl:variable name="step" select="common:result/attributes/item[@key='step']/value/text()" />
<xsl:variable name="url" select="common:result/attributes/item[@key='url']/value/text()" />
<div class="tile">
	<div class="titleFont3" style="margin-bottom: 10px;">Список агентов</div>
	<c:choose>
	<c:when test="${not empty agents}">
	<c:forEach var="item" varStatus="status" items="${agents}">
	<div class="flexRow itemBlock">
		<div class="flexColumn">
			<div class="titleFont2">Агент: <c:choose><c:when test="${not empty item.name}">${item.name}</c:when><c:otherwise>без названия</c:otherwise></c:choose></div>
			<div class="flexColumn itemBlockParams">
				<div class="paramColor">Тариф: <span>${item.tariffTitle}</span></div>
				<div class="paramColor">Статус: <span>${item.nextStatusString}</span></div>
				<div class="paramColor">Состояние подписки: <span>${item.statusString}</span></div>
				<div class="paramColor">Ссылка на загрузку: <span>
						<a href="${downloadUrl}?os=windows&amp;id=${item.agentUUID}">Windows</a>,
						<a href="${downloadUrl}?os=linux&amp;arch=x86_64&amp;id=${item.agentUUID}">Linux x86_64</a>,
						<a href="${downloadUrl}?os=linux&amp;arch=x86&amp;id=${item.agentUUID}">Linux x86</a>,
						<a href="${downloadUrl}?os=macosx&amp;id=${item.agentUUID}">OS X</a>,
						<a href="${downloadUrl}?os=android4&amp;id=${item.agentUUID}">Android (4+)</a>
				</span></div>
				<div class="paramColor">UUID: <span>${item.agentUUID}</span></div>
			</div>
		</div>
		<div class="flexRow" style="align-content: center;">
			<div onclick="showBlock( 'drwebRoot', 'change', { ...drwebQuery, agentId: ${item.id} } );"><img src="img/edit.png" title="Редактировать" class="iconButton"/></div>
		</div>
	</div>
	<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
	</c:when>
	<c:otherwise><div class="notFound" style="margin: 20px;">данные не найдены</div></c:otherwise>
	</c:choose>

	<c:if test="${maxAgentCount == -1 or fn:length(agents) < maxAgentCount}"><div style="margin: 35px 20px 10px 20px;"><button class="button1" onclick="showBlock( 'drwebRoot', 'addAgent1', { ...drwebQuery } ); return true;">Добавить нового агента</button></div></c:if>
</div>