<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru">
	<xsl:import href="layout.xsl" />
	<xsl:template name="title">
		<xsl:choose>
			<xsl:when
				test="data/common:result/attributes/item[@key='change']/value/text()">
				Dr.Web AV-Desk - Управление агентом
			</xsl:when>
			<xsl:when test="data/@action = 'GetUrl'">
				Dr.Web AV-Desk - подписка
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/data">
		<xsl:choose>
			<xsl:when test="common:result/attributes/item[@key='change']/value/text()">
				<xsl:call-template name="change" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="GetUrl" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- получение нового агента -->
	<xsl:template name="GetUrl">
		<xsl:if test="common:result/attributes/item[@key='error']/value/text()">
			<xsl:call-template name="error">
				<xsl:with-param name="text">
					<xsl:value-of
						select="common:result/attributes/item[@key='error']/value/text()" />
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="module" select="/data/@module" />
		<xsl:variable name="mid" select="/data/@mid" />
		<xsl:variable name="step"
			select="common:result/attributes/item[@key='step']/value/text()" />
		<xsl:variable name="url"
			select="common:result/attributes/item[@key='url']/value/text()" />
		<div class="report" style="width:800px">
			<table cellspacing='1' style="width:100%">
				<head>
					<tr>
						<td>Агент</td>
						<td>Тариф</td>
						<td>Состояние подписки</td>
						<td>Статус</td>
						<td>Ссылка на загрузку</td>
					</tr>
				</head>
				<body>
					<xsl:for-each select="common:result/data/item">
						<tr>
							<td>
								<a title="CSV"
									href="{$WEBEXECUTER}?module=drweb&amp;mid={/data/@mid}&amp;action=GetUrl&amp;operation=change&amp;agentId={@id}">
									<xsl:value-of select="@description" />
									<br/>(<xsl:value-of select="@agentUUID" />)
								</a>
							</td>
							
							<td>
								<xsl:value-of 
								select="@tariffTitle" />
							</td>
							<td align="center">
								<xsl:value-of select="@statusString" />
							</td>
							<td align="center">
								<xsl:value-of select="@nextStatusString" />
							</td>
							<td align="center">
							Скачать 		
							<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=windows&amp;id={@agentUUID}">Windows</a>,
							<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86_64&amp;id={@agentUUID}">Linux x86_64</a>,
							<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86&amp;id={@agentUUID}">Linux x86</a>,
							<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=macosx&amp;id={@agentUUID}">OS X</a>,
							<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=android4&amp;id={@agentUUID}">Android (4+)</a>
							</td>
						</tr>
					</xsl:for-each>
				</body>
			</table>
			<br />
			<xsl:choose>
				<xsl:when test="$step= '1' ">
					<table cellspacing='1' style="width:100%">
						<body>
							<tr>
								<td>Заведен агент для пользователя</td>
								<td>
									<xsl:value-of 	select="common:result/attributes/item[@key='agent']/value/@description" />
									(
									<xsl:value-of
										select="common:result/attributes/item[@key='agent']/value/@agentUUID" />
									)
								</td>
							</tr>
							<tr>
								<td>Ссылка для скачивания</td>
								<td>
									<xsl:variable name="uid" select="common:result/attributes/item[@key='agent']/value/@agentUUID" />
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=windows&amp;id={$uid}">Windows</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86_64&amp;id={$uid}">Linux x86_64</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86&amp;id={$uid}">Linux x86</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=macosx&amp;id={$uid}">OS X</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=android4&amp;id={$uid}">Android (4+)</a>
								</td>
							</tr>
						</body>
					</table>
				</xsl:when>
				<xsl:when test="$step= '0' ">
					<div>
						<form method='post' action='{$WEBEXECUTER}'>
							<input type="hidden" name="step" value="1" />
							<select class="gradbtn ">
								<xsl:attribute name="name">tariff</xsl:attribute>
								<xsl:for-each
									select="common:result/attributes/item[@key='tariffs']/value/item">
									<option value="{@id}">
										<xsl:value-of select="@title" />
									</option>
								</xsl:for-each>
							</select>
							<br />
							<br />

							<xsl:call-template name="action" />
							
							<script language="javascript" type="text/javascript">
							<xsl:text disable-output-escaping="yes">
							<![CDATA[
							function checkAndSubmit()
							{
								var elem = document.getElementById('licenseYes');
								if(!elem.checked)
								{
									alert("Вы не приняли условия лицензионного соглашения");
								}
								else
								{
									elem.form.submit();
								}
							}
								]]>
							</xsl:text>
						</script>
							Прочтите 
							<a href="#" onclick="window.open('drweb_license.pdf', 'popup', 'width=640, height=600')">
								лицензионное соглашение 
							</a>
							и нажмите '<b>Я принимаю условия лицензионного соглашения</b>' только в том случае, если Вы принимаете данное лицензионное соглашение.
							<br/>
							<input type="checkbox" id="licenseYes"><b>Я принимаю условия лицензионного соглашения</b></input>
							<br/>
							<br/>
							<xsl:call-template name="button" >
								<xsl:with-param name="title" select="'Получить Dr.Web'" />
								<xsl:with-param name="onclick" select="'checkAndSubmit()'" />
							</xsl:call-template>
						</form>
						
					</div>
				</xsl:when>
			</xsl:choose>
		</div>
	</xsl:template>


	<xsl:template name="change">
	<xsl:if test="common:result/attributes/item[@key='error']/value/text()">
			<xsl:call-template name="error">
				<xsl:with-param name="text">
					<xsl:value-of
						select="common:result/attributes/item[@key='error']/value/text()" />
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<div class="report" style="width:800px">
		<table cellspacing='1' style="width:100%">
				<head>
					<tr>
						<td>Агент</td>
						<td>Тариф</td>
						<td>Состояние подписки</td>
						<td>Статус</td>
						<td>Ссылка на загрузку</td>
					</tr>
				</head>
				<body>
						<tr>
							<td>
								(<xsl:value-of select="common:result/attributes/item[@key='agent']/value/@agentUUID" />)
							</td>
							<td>
								<xsl:value-of 
								select="common:result/attributes/item[@key='agent']/value/@tariffTitle" />
							</td>
							<td align="center">
								<xsl:value-of select="common:result/attributes/item[@key='agent']/value/@statusString" />
							</td>
							<td align="center">
								<xsl:value-of select="common:result/attributes/item[@key='agent']/value/@nextStatusString" />
							</td>
							<td>
									<xsl:variable name="uid" select="common:result/attributes/item[@key='agent']/value/@agentUUID" />
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=windows&amp;id={$uid}">Windows</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86_64&amp;id={$uid}">Linux x86_64</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=linux&amp;arch=x86&amp;id={$uid}">Linux x86</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=macosx&amp;id={$uid}">OS X</a>,
									<a href="{/data/common:result/attributes/item[@key='downloadUrl']/value/text()}?os=android4&amp;id={$uid}">Android (4+)</a>
								</td>
						</tr>
				</body>
			</table>
			<br />
			<form method='get' action='{$WEBEXECUTER}'>
				<table cellspacing='1' style="width:100%">
					<body>
						<tr >
							<td style="text-align:left;">
								<input type="radio" name="operation" value="changeTariff"/>
								Сменить тариф на
								<select class="gradbtn ">
										<xsl:attribute name="name">tariff</xsl:attribute>
										<xsl:for-each
											select="common:result/attributes/item[@key='tariffs']/value/item">
											<option value="{@groupTitle}">
										
												<xsl:value-of select="@title" />
											</option>
										</xsl:for-each>
									</select>
								
							</td >
							<td  style="text-align:left;">
								<input type="radio" name="operation" value="block"/>
								Приостановить подписку на 
									<select class="gradbtn " name='monthCount'>
										<option value="1">1 месяц </option>
										<option value="2">2 месяца</option>
										<option value="3">3 месяца</option>
									</select>
								
							</td>
						</tr>
						<tr>
							<td  style="text-align:left;">
								<input type="radio" name="operation" value="active"/>
								Активировать подписку
							</td>
							<td  style="text-align:left;">
								<input type="radio" name="operation" value="delete"/>
								Прекратить подписку
							</td>
						</tr>
					</body>
				</table>
				<br/>
				<input type="hidden" name="agentId"
									value="{common:result/attributes/item[@key='agent']/value/@id}" />
				<xsl:call-template name="action" />
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="Сохранить" />
				</xsl:call-template>
				</form>
			</div>
	</xsl:template>
</xsl:stylesheet>