/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.bean.condition;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchBalanceCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.base.DispatchConditionChecker;
import ru.bitel.common.Preferences;

public class DispatchBalanceConditionChecker
implements DispatchConditionChecker {
    @Override
    public boolean check(Connection con, DispatchCondition condition, Dispatch dispatch, Subscription subscribtion) throws BGException {
        boolean result;
        DispatchBalanceCondition adCondition = (DispatchBalanceCondition)condition;
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal balanceLimit = null;
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            balance = balanceUtils.getBalance(new Date(), subscribtion.getContractId());
        }
        if (adCondition.isLimit()) {
            balanceLimit = this.getBalanceLimit(con, subscribtion.getContractId());
        }
        BigDecimal cBalance = balance.subtract(adCondition.isLimit() ? balanceLimit : BigDecimal.ZERO);
        boolean bl = result = !(adCondition.getLeft() != null && cBalance.compareTo(adCondition.getLeft()) < 0 || adCondition.getRight() != null && cBalance.compareTo(adCondition.getRight()) > 0);
        if (dispatch.isPersonal()) {
            int moduleId = 0;
            Preferences prefs = subscribtion.getPreferences();
            BigDecimal left = prefs.getBigDecimal(moduleId + ".from_balance", null);
            BigDecimal right = prefs.getBigDecimal(moduleId + ".to_balance", null);
            boolean limit = prefs.getBoolean(moduleId + ".limit", false);
            if (limit && balanceLimit == null) {
                balanceLimit = this.getBalanceLimit(con, subscribtion.getContractId());
            }
            cBalance = balance.subtract(limit ? balanceLimit : BigDecimal.ZERO);
            boolean subscriptionPrefsResult = !(left != null && cBalance.compareTo(left) < 0 || right != null && cBalance.compareTo(right) > 0);
            boolean bl2 = result = result && subscriptionPrefsResult;
        }
        if (adCondition.isFreq()) {
            boolean update = true;
            long freqCounter = 0L;
            if (result) {
                freqCounter = subscribtion.getPreferences().getLong("freq.counter", 0L);
                if (freqCounter < (long)adCondition.getFreqCount()) {
                    ++freqCounter;
                } else {
                    update = false;
                    result = false;
                }
            }
            if (update && subscribtion.getPreferences().getLong("freq.counter", 0L) != freqCounter) {
                subscribtion.getPreferences().set("freq.counter", String.valueOf(freqCounter));
                subscribtion.setUpdate(true);
            }
        }
        return result;
    }

    private BigDecimal getBalanceLimit(Connection con, int contractId) throws BGException {
        BigDecimal balanceLimit = BigDecimal.ZERO;
        try (ContractDao contractDao = new ContractDao(con, 0);){
            balanceLimit = ((Contract)contractDao.get(contractId)).getBalanceLimit();
        }
        return balanceLimit;
    }
}

