/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionGetTopicTable
extends ActionBase {
    public void doAction() throws BGException {
        Page page = this.getPage();
        Boolean closed = this.getBooleanParameter("closed");
        Boolean onlynew = this.getBooleanParameter("onlynew");
        Period period = this.getPeriod();
        int tid = this.getIntParameter("tid", -1);
        String message = this.getParameter("message");
        int status = this.getIntParameter("status", -1);
        String title = this.getParameter("title");
        String userselect = this.getParameter("userselect");
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Map<Integer, String> ms = topicManager.getStatusesMap();
        TopicListFilter topicListFilter = new TopicListFilter();
        topicListFilter.setContractId(this.cid);
        topicListFilter.setClosed(closed);
        topicListFilter.setPage(page);
        topicListFilter.setOnlyNew(onlynew);
        topicListFilter.setPeriod(period);
        topicListFilter.setTitle(title);
        topicListFilter.setUserselect(userselect);
        topicListFilter.setUserId(this.userId);
        topicListFilter.setTopicId(tid);
        topicListFilter.setMessage(message);
        topicListFilter.setStatus(status);
        List<Topic> topicList = topicManager.getTopicList(topicListFilter);
        for (Topic topic : topicList) {
            String st = null;
            st = topic.getStatus() == 0 ? "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d" : (!ms.containsKey(topic.getStatus()) ? "?" : ms.get(topic.getStatus()));
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(topic.getId()));
            row.setAttribute("subject", topic.getTitle());
            row.setAttribute("state", topic.isClosed() ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430");
            row.setAttribute("status", st);
            row.setAttribute("date", TimeUtils.format((Date)topic.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("dateClose", TimeUtils.format((Date)topic.getDateClose(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("comm", Topic.commPrefix[topic.getComm()] + topic.getCommValue());
            row.setAttribute("lastmessage", TimeUtils.format((Date)topic.getLastMessageDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("user", topic.getUserName());
            row.setAttribute("userId", String.valueOf(topic.getUserId()));
            row.setAttribute("package", String.valueOf(topic.getContractPackageId() > 0));
            row.setAttribute("cost", String.valueOf(topic.getCost()));
            row.setAttribute("messages", topic.getMessageCount() + " [ " + topic.getMessageNewUserCount() + " ]");
            row.setAttribute("auto_close", String.valueOf(topic.isAutoClose()));
            row.setAttribute("categoryId", String.valueOf(topic.getCategoryId()));
            row.setAttribute("subcategoryId", String.valueOf(topic.getSubcategoryId()));
        }
        page.setRecordCount(topicManager.getTopicCount(topicListFilter));
        this.setPageAttribute(table, page);
    }
}

