/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.task;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;

public class NewMessageChecker
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    private final String DEFAULT_MAIL_SUBJECT = "HelpDesk => {countAll} - \u0432\u0441\u0435\u0433\u043e \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0435\u043d\u043d\u044b\u0445, {countDay} - \u043d\u043e\u0432. \u0441\u043e\u043e\u0431\u0449. \u0437\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f, {countHour} - \u043d\u043e\u0432. \u0441\u043e\u043e\u0431\u0449. \u0437\u0430 \u043f\u043e\u0441\u043b. \u0447\u0430\u0441";

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d HelpDesk. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0438\u0441\u044c\u043c\u0430 \u043e \u043d\u043e\u0432\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f\u0445.";
    }

    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            String contractTitleRegexp = this.taskSetup.get("contract.title.regexp", null);
            Long contractGroupBitMask = null;
            try {
                contractGroupBitMask = Long.valueOf(this.taskSetup.get("contract.group.mask", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            TopicManager topicManager = new TopicManager(con, this.plugin);
            int messageCountAll = topicManager.getClientNewMessageCount(contractTitleRegexp, contractGroupBitMask, 0);
            if (messageCountAll > 0) {
                int messageCountDay = topicManager.getClientNewMessageCount(contractTitleRegexp, contractGroupBitMask, 1);
                int messageCountHour = topicManager.getClientNewMessageCount(contractTitleRegexp, contractGroupBitMask, 2);
                String mails = this.taskSetup.get("mail.to", "");
                if (!mails.isEmpty()) {
                    MailMsg msg = new MailMsg((Preferences)this.setup);
                    String subject = this.taskSetup.get("mail.subject", "HelpDesk => {countAll} - \u0432\u0441\u0435\u0433\u043e \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0435\u043d\u043d\u044b\u0445, {countDay} - \u043d\u043e\u0432. \u0441\u043e\u043e\u0431\u0449. \u0437\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f, {countHour} - \u043d\u043e\u0432. \u0441\u043e\u043e\u0431\u0449. \u0437\u0430 \u043f\u043e\u0441\u043b. \u0447\u0430\u0441");
                    subject = this.replaceParam(subject, messageCountAll, messageCountDay, messageCountHour);
                    String body = this.taskSetup.get("mail.body", "");
                    body = this.replaceParam(body, messageCountAll, messageCountDay, messageCountHour);
                    body = body.replaceAll("\\\\n", "\n");
                    msg.sendMessage(mails, subject, body);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private String replaceParam(String param, int countAll, int countDay, int countHour) {
        String result = param.replaceAll("\\{countAll\\}", String.valueOf(countAll));
        result = result.replaceAll("\\{countDay\\}", String.valueOf(countDay));
        return result.replaceAll("\\{countHour\\}", String.valueOf(countHour));
    }
}

