/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskPackageTab;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class HelpdeskPackageEditor
extends BGPanel {
    private BGTable table = new BGTable();
    private HelpdeskPackageTab panel = null;
    private BGButtonPanelOkCancel panelOkCancel = new BGButtonPanelOkCancel();

    public HelpdeskPackageEditor(HelpdeskPackageTab packagePanel) {
        this.panel = packagePanel;
        this.jbInit();
    }

    private void jbInit() {
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("package"), "package");
        this.panelOkCancel.getButtonOk().setText("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.panelOkCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if ("ok".equals(event.getActionCommand())) {
                    HelpdeskPackageEditor.this.updateData();
                } else {
                    HelpdeskPackageEditor.this.setVisible(false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.panelOkCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.getContext().getModule());
        request.setContractId(this.getContext().getContractId());
        request.setAction("GetPackageList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(doc);
        }
    }

    public void updateData() {
        String id = ClientUtils.getRowId((BGTable)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442!", null);
        if (id != null) {
            Request request = new Request();
            request.setModule(this.getContext().getModule());
            request.setContractId(this.getContext().getContractId());
            request.setAction("UpdateContractPackage");
            request.setAttribute("id", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setVisible(false);
                this.panel.performAction("refresh");
            }
        }
    }
}

