<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:if test="${not empty contractIds}">
<div style="margin: 60px 20px 20px 20px;">
	<div class="contractHeader">Договор
	[<c:forEach var="item" items="${contractIds}">
		<span onclick="showBlock( 'contracts', context + '/assistant/contract/${item}' );">${item}</span>
	</c:forEach>] 
	</div>
	<div class="tile">
	<div class="p">
		<span class="n">№</span><span class="v">${contract.title}</span>
		<span class="n" style="font-size: 0.8rem; padding-right: 5px;">[<fmt:formatDate value="${contract.dateFrom}" dateStyle="SHORT"/> - <fmt:formatDate value="${contract.dateTo}"/>]</span><span class="g"></span>
		<span class="n">Статус:</span><span class="v">${contractStatus}</span>
	</div>
	<div class="contractComment">${contract.comment}</div>
	<div class="blockSeparator">Тариф(ы)</div>
	<c:forEach var="item" items="${contractTariffs}">
		<div class="flexRow" style="">
		<div class="tariffTitle">${item.tariffPlan}</div>
		<div><span class="n" style="font-size: 0.8rem;">[<fmt:formatDate value="${item.period.dateFrom}" dateStyle="SHORT"/> - <fmt:formatDate value="${item.period.dateTo}"/>]</span></div>
		</div>
	</c:forEach>
	<div class="blockSeparator">Финансы</div>
	<div class="flexRow">
		<div class="p"><span class="n">Баланс:</span><span class="v"><fmt:formatNumber value="${contractBalance}"/>&nbsp;&#8381;</span></div>
		<div class="p"><span class="n">Лимит:</span><span class="v">${contract.balanceLimit}&nbsp;&#8381;</span></div>
	</div>	
	<div class="lineSeparator">Приходы</div>
	<c:forEach var="item" varStatus="status" items="${contractPayments}">
	<div class="flexRow" style="margin-bottom: 5px;">
		<div>
			<span class="finDate" style="padding-right: 10px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT"/></span>
			<span class="finTitle">${contractPaymentTypes[item.typeId].title}</span>
			<c:if test="${not empty item.comment}"><br><span class="finComment" style="padding-left: 20px;">${item.comment}</span></c:if>
		</div>
		<div class="finSum"><fmt:formatNumber value="${item.sum}"/>&nbsp;&#8381;</div>
	</div>
	<c:if test="${not status.last}"><div class="itemSeparator"></div></c:if>
	</c:forEach>
	<div class="lineSeparator">Расходы</div>
	<c:forEach var="item" varStatus="status" items="${contractCharges}">
	<div class="flexRow" style="margin-bottom: 5px;">
		<div>
			<span class="finDate" style="padding-right: 10px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT"/></span>
			<span class="finTitle">${contractChargeTypes[item.typeId].title}</span>
			<c:if test="${not empty item.comment}"><br><span class="finComment" style="padding-left: 20px;">${item.comment}</span></c:if>
		</div>
		<div class="finSum"><fmt:formatNumber value="${item.sum}"/>&nbsp;&#8381;</div>
	</div>
	<c:if test="${not status.last}"><div class="itemSeparator"></div></c:if>
	</c:forEach>
	<div class="lineSeparator">Наработка</div>
	<c:forEach var="item" varStatus="status" items="${contractAccounts}">
	<div class="flexRow">
		<div style="flex-shrink: 0;"><span class="finDate" style="padding-right: 10px;"><fmt:formatDate value="${item.date}" pattern="LLLL yyyy"/></span></div>
		<div><span class="finTitle">${item.title}</span></div>
		<div class="finSum" style="padding-left: 10px;"><fmt:formatNumber value="${item.sum}"/>&nbsp;&#8381;</div>
	</div>
	<c:if test="${not status.last}"><div class="itemSeparator"></div></c:if>
	</c:forEach>
	</div>
</div>
</c:if>