function showAction( id, actionId, formData )
{
	jQuery.ajax( context + "/assistant/action/" + actionId, formData )
		.done( function( data ) 
		{
			let divEl = jQuery("div#"+id);
			if ( typeof divEl !== 'undefined' )
			{
				divEl.html( data );
			}
		} );	
	return false;
}

function doButton( buttonCode, actionId, formData )
{
	let query = Object.assign( {} );
	let a = { method: "POST", dataType: "json", data: query };
	if ( formData !== undefined ) {
		let f = new FormData(formData);
		let formFiled = {};
		for ( let [name, value] of f)
		{
			formFiled[name] = value;
		}		
		query['data'] = JSON.stringify(formFiled);
		//operation.set( 'module', inQuery.module );
		//operation.set( 'mid', inQuery.mid );
		//operation.set( 'contractId', inQuery.contractId );
		//query = operation;
		//processData = false;
		//contentType = false;
	}	
	jQuery.ajax( context + "/assistant/doButton/" + buttonCode + "/" + actionId, a )
		.done( function( data ) 
		{
 			if ( data.fields !== undefined && data.fields.openContract !== undefined )
			{
				showBlock( "contracts", context + "/assistant/contract/" + data.fields.openContract );
			}			
			if ( data.status == 'error' )
			{
				alert( data.error );
			}
			else if ( data.nextActionId !== undefined )
			{
				hideMenu();
				showAction( "action", data.nextActionId, a );
			}
			else
			{
				showMenu();
			}
		} );	
	return false;
}

function showBlock( id, url, inParam )
{
	let processData = true;
	let contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
	let query = Object.assign({}, inParam);
//	if ( typeof operation == 'string' ) {
//		query.operation = operation; 
//	} 
//	else if ( operation instanceof FormData ) {
//		operation.set( 'action', inQuery.action );
//		operation.set( 'module', inQuery.module );
//		operation.set( 'mid', inQuery.mid );
//		operation.set( 'contractId', inQuery.contractId );
//		query = operation;
//		processData = false;
//		contentType = false;
//	}
//	else { jQuery.extend( query, operation ) };
    jQuery.ajax(
	{
		url: url,
		type: 'POST',
		dataType: 'html',    
		data: query,
		processData: processData,
	    contentType: contentType,		
		success: function( data )
		{
			let divEl = jQuery("div#"+id);
			if ( typeof divEl !== 'undefined' )
			{
				divEl.html( data );
			}
		}
	});
	return false;
}

function showMenu()
{
	jQuery("div#action").html( "" );
	return showBlock( "menu", context + "/assistant/menu" );
}

function hideMenu()
{
	jQuery("div#menu").html( "" );
}